/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.strategy.selectors.variables;

import gnu.trove.list.array.TIntArrayList;
import java.util.Random;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.search.loop.monitors.FailPerPropagator;
import org.chocosolver.solver.search.strategy.assignments.DecisionOperatorFactory;
import org.chocosolver.solver.search.strategy.decision.Decision;
import org.chocosolver.solver.search.strategy.selectors.values.IntValueSelector;
import org.chocosolver.solver.search.strategy.strategy.AbstractStrategy;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.objects.IntMap;

public class DomOverWDeg
extends AbstractStrategy<IntVar> {
    private FailPerPropagator counter;
    private IntMap pid2arity;
    private TIntArrayList bests;
    private Random random;
    private IntValueSelector valueSelector;

    public DomOverWDeg(IntVar[] variables, long seed, IntValueSelector valueSelector) {
        super((Variable[])variables);
        Model model = variables[0].getModel();
        this.counter = new FailPerPropagator(model.getCstrs(), model);
        this.pid2arity = new IntMap(model.getCstrs().length * 3 / 2 + 1, -1);
        this.bests = new TIntArrayList();
        this.valueSelector = valueSelector;
        this.random = new Random(seed);
    }

    @Override
    public Decision<IntVar> computeDecision(IntVar variable) {
        if (variable == null || variable.isInstantiated()) {
            return null;
        }
        int currentVal = this.valueSelector.selectValue(variable);
        return variable.getModel().getSolver().getDecisionPath().makeIntDecision(variable, DecisionOperatorFactory.makeIntEq(), currentVal);
    }

    @Override
    public Decision<IntVar> getDecision() {
        IntVar best = null;
        this.bests.resetQuick();
        this.pid2arity.clear();
        long _d1 = Integer.MAX_VALUE;
        long _d2 = 0L;
        for (int idx = 0; idx < ((IntVar[])this.vars).length; ++idx) {
            int dsize = ((IntVar[])this.vars)[idx].getDomainSize();
            if (dsize <= 1) continue;
            long c1 = (long)dsize * _d2;
            int weight = this.weight(((IntVar[])this.vars)[idx]);
            long c2 = _d1 * (long)weight;
            if (c1 < c2) {
                this.bests.clear();
                this.bests.add(idx);
                _d1 = dsize;
                _d2 = weight;
                continue;
            }
            if (c1 != c2) continue;
            this.bests.add(idx);
        }
        if (this.bests.size() > 0) {
            int currentVar = this.bests.get(this.random.nextInt(this.bests.size()));
            best = ((IntVar[])this.vars)[currentVar];
        }
        return this.computeDecision(best);
    }

    private int weight(IntVar v) {
        int w = 1;
        int nbp = v.getNbProps();
        for (int i = 0; i < nbp; ++i) {
            Propagator prop = v.getPropagator(i);
            int pid = prop.getId();
            if (this.pid2arity.get(pid) > -1) {
                w += this.counter.getFails(prop);
                continue;
            }
            int futVars = prop.arity();
            assert (futVars > -1);
            this.pid2arity.put(pid, futVars);
            if (futVars <= 1) continue;
            w += this.counter.getFails(prop);
        }
        return w;
    }
}

