/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.strategy.selectors.variables;

import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TIntDoubleHashMap;
import java.util.BitSet;
import java.util.Comparator;
import java.util.Random;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.search.limits.FailCounter;
import org.chocosolver.solver.search.loop.monitors.IMonitorDownBranch;
import org.chocosolver.solver.search.loop.monitors.IMonitorInitialize;
import org.chocosolver.solver.search.loop.monitors.IMonitorRestart;
import org.chocosolver.solver.search.loop.move.Move;
import org.chocosolver.solver.search.loop.move.MoveRestart;
import org.chocosolver.solver.search.restart.MonotonicRestartStrategy;
import org.chocosolver.solver.search.strategy.assignments.DecisionOperatorFactory;
import org.chocosolver.solver.search.strategy.decision.Decision;
import org.chocosolver.solver.search.strategy.strategy.AbstractStrategy;
import org.chocosolver.solver.variables.IVariableMonitor;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IEventType;
import org.chocosolver.util.iterators.DisposableValueIterator;
import org.chocosolver.util.objects.IntMap;

public class ActivityBased
extends AbstractStrategy<IntVar>
implements IMonitorDownBranch,
IMonitorRestart,
IMonitorInitialize,
IVariableMonitor<IntVar>,
Comparator<IntVar> {
    private static final double ONE = 1.0;
    private static final double[] distribution = new double[]{999.99, 12.706f, 4.303f, 3.182f, 2.776f, 2.571f, 2.447f, 2.365f, 2.306f, 2.262f, 2.228f, 2.201f, 2.179f, 2.16f, 2.145f, 2.131f, 2.12f, 2.11f, 2.101f, 2.093f, 2.086f, 2.08f, 2.074f, 2.069f, 2.064f, 2.06f, 2.056f, 2.052f, 2.048f, 2.045f, 2.042f, 2.04f, 2.037f, 2.035f, 2.032f, 2.03f, 2.028f, 2.026f, 2.024f, 2.023f, 2.021f, 2.0, 1.99f, 1.984f, 1.98f, 1.977f, 1.975f, 1.973f, 1.972f, 1.969f, 1.96f};
    private final Model model;
    private final IntMap v2i;
    private final IntVar[] vars;
    private final double[] A;
    private final double[] mA;
    private final double[] sA;
    private final IVal[] vAct;
    private final BitSet affected;
    private final double g;
    private final double d;
    private final int a;
    private boolean sampling;
    private int nb_probes;
    private int samplingIterationForced = 1;
    private Random random;
    private int currentVar = -1;
    private int currentVal = -1;
    private TIntList bests = new TIntArrayList();
    private boolean restartAfterEachFail = true;
    private Move rfMove;
    private boolean hasBeenInitiaized;

    private static double distribution(int n) {
        if (n <= 0) {
            throw new UnsupportedOperationException();
        }
        if (n > 0 && n < 41) {
            return distribution[n - 1];
        }
        if (n < 61) {
            return distribution[40];
        }
        if (n < 81) {
            return distribution[41];
        }
        if (n < 101) {
            return distribution[42];
        }
        if (n < 121) {
            return distribution[43];
        }
        if (n < 141) {
            return distribution[44];
        }
        if (n < 161) {
            return distribution[45];
        }
        if (n < 181) {
            return distribution[46];
        }
        if (n < 201) {
            return distribution[47];
        }
        if (n < 251) {
            return distribution[48];
        }
        return distribution[49];
    }

    public ActivityBased(Model model, IntVar[] vars, double g, double d, int a, int samplingIterationForced, long seed) {
        super((Variable[])vars);
        this.model = model;
        this.vars = vars;
        this.A = new double[vars.length];
        this.mA = new double[vars.length];
        this.sA = new double[vars.length];
        this.vAct = new IVal[vars.length];
        this.affected = new BitSet(vars.length);
        this.v2i = new IntMap(vars.length);
        for (int i = 0; i < vars.length; ++i) {
            this.v2i.put(vars[i].getId(), i);
            vars[i].addMonitor(this);
        }
        assert (g >= 0.0 && g <= 1.0);
        this.g = g;
        assert (d >= 0.0 && d <= 1.0);
        this.d = d;
        assert (a > 0);
        this.a = a;
        this.sampling = true;
        this.random = new Random(seed);
        this.nb_probes = 0;
        this.samplingIterationForced = samplingIterationForced;
        model.getSolver().setRestartOnSolutions();
        if (this.restartAfterEachFail) {
            this.rfMove = new MoveRestart(model.getSolver().getMove(), new MonotonicRestartStrategy(1), new FailCounter(model.getSolver().getModel(), 1L), Integer.MAX_VALUE);
            model.getSolver().setMove(this.rfMove);
        }
        model.getSolver().plugMonitor(this);
    }

    public ActivityBased(IntVar[] vars) {
        this(vars[0].getModel(), vars, 0.999, 0.2, 8, 1, 0L);
    }

    @Override
    public boolean init() {
        this.hasBeenInitiaized = true;
        for (int i = 0; i < this.vars.length; ++i) {
            int ampl = this.vars[i].getUB() - this.vars[i].getLB() + 1;
            this.vAct[i] = ampl > 512 ? new MapVal(this.vars[i].getLB()) : new ArrayVal(ampl, this.vars[i].getLB());
        }
        return true;
    }

    @Override
    public void afterInitialize() {
        if (!this.hasBeenInitiaized) {
            this.model.getSolver().unplugMonitor(this);
        }
    }

    @Override
    public Decision<IntVar> computeDecision(IntVar variable) {
        if (variable == null || variable.isInstantiated()) {
            return null;
        }
        if (this.currentVar == -1 || this.vars[this.currentVar] != variable) {
            if (this.sampling) {
                return null;
            }
            for (int i = 0; i < this.vars.length; ++i) {
                if (this.vars[i] != variable) continue;
                this.currentVar = i;
            }
            assert (this.vars[this.currentVar] == variable);
        }
        this.currentVal = variable.getLB();
        if (this.sampling) {
            int ds = variable.getDomainSize();
            int n = this.random.nextInt(ds);
            if (variable.hasEnumeratedDomain()) {
                while (n-- > 0) {
                    this.currentVal = variable.nextValue(this.currentVal);
                }
            } else {
                this.currentVal += n;
            }
        } else if (variable.hasEnumeratedDomain()) {
            this.bests.clear();
            double bestVal = Double.MAX_VALUE;
            DisposableValueIterator it = variable.getValueIterator(true);
            while (it.hasNext()) {
                int value = it.next();
                double current = this.vAct[this.currentVar].activity(value);
                if (current < bestVal) {
                    this.bests.clear();
                    this.bests.add(value);
                    bestVal = current;
                    continue;
                }
                this.bests.add(value);
            }
            this.currentVal = this.bests.get(this.random.nextInt(this.bests.size()));
        } else {
            int lb = variable.getLB();
            int ub = variable.getUB();
            this.currentVal = this.vAct[this.currentVar].activity(lb) < this.vAct[this.currentVar].activity(ub) ? lb : ub;
        }
        return this.model.getSolver().getDecisionPath().makeIntDecision(variable, DecisionOperatorFactory.makeIntEq(), this.currentVal);
    }

    @Override
    public Decision<IntVar> getDecision() {
        assert (this.hasBeenInitiaized);
        IntVar best = null;
        this.bests.clear();
        double bestVal = -1.0;
        for (int i = 0; i < this.vars.length; ++i) {
            int ds = this.vars[i].getDomainSize();
            if (ds <= 1) continue;
            double a = this.A[this.v2i.get(this.vars[i].getId())] / (double)ds;
            if (a > bestVal) {
                this.bests.clear();
                this.bests.add(i);
                bestVal = a;
                continue;
            }
            if (a != bestVal) continue;
            this.bests.add(i);
        }
        if (this.bests.size() > 0) {
            this.currentVar = this.bests.get(this.random.nextInt(this.bests.size()));
            best = this.vars[this.currentVar];
        }
        return this.computeDecision(best);
    }

    @Override
    public int compare(IntVar o1, IntVar o2) {
        double b2;
        if (this.sampling) {
            return this.random.nextBoolean() ? 1 : -1;
        }
        int id1 = this.v2i.get(o1.getId());
        int id2 = this.v2i.get(o2.getId());
        double b1 = this.A[id1] * (double)o2.getDomainSize();
        if (b1 > (b2 = this.A[id2] * (double)o1.getDomainSize())) {
            return -1;
        }
        if (b1 < b2) {
            return 1;
        }
        return 0;
    }

    public double getActivity(IntVar var) {
        if (this.v2i.containsKey(var.getId())) {
            return this.A[this.v2i.get(var.getId())] / (double)var.getDomainSize();
        }
        return 0.0;
    }

    @Override
    public void onUpdate(IntVar var, IEventType evt) {
        this.affected.set(this.v2i.get(var.getId()));
    }

    @Override
    public void beforeDownBranch(boolean left) {
        if (left) {
            this.affected.clear();
        }
    }

    @Override
    public void afterDownBranch(boolean left) {
        if (left && this.currentVar > -1) {
            for (int i = 0; i < this.A.length; ++i) {
                if (this.vars[i].getDomainSize() > 1) {
                    int n = i;
                    this.A[n] = this.A[n] * (this.sampling ? 1.0 : this.g);
                }
                if (!this.affected.get(i)) continue;
                int n = i;
                this.A[n] = this.A[n] + 1.0;
            }
            double act = this.vAct[this.currentVar].activity(this.currentVal);
            if (this.sampling) {
                this.vAct[this.currentVar].setactivity(this.currentVal, act + (double)this.affected.cardinality());
            } else {
                this.vAct[this.currentVar].setactivity(this.currentVal, (act * (double)(this.a - 1) + (double)this.affected.cardinality()) / (double)this.a);
            }
            this.currentVar = -1;
        }
    }

    @Override
    public void beforeRestart() {
    }

    @Override
    public void afterRestart() {
        if (this.sampling) {
            int idx;
            ++this.nb_probes;
            for (int i = 0; i < this.A.length; ++i) {
                double activity = this.A[i];
                double oldmA = this.mA[i];
                double U = activity - oldmA;
                int n = i;
                this.mA[n] = this.mA[n] + U / (double)this.nb_probes;
                int n2 = i;
                this.sA[n2] = this.sA[n2] + U * (activity - this.mA[i]);
                this.A[i] = 0.0;
                this.vAct[i].update(this.nb_probes);
            }
            for (idx = 0; idx < this.vars.length && this.checkInterval(idx); ++idx) {
            }
            if (this.nb_probes > this.samplingIterationForced && idx == this.vars.length) {
                this.sampling = false;
                if (this.restartAfterEachFail) {
                    Solver sl = this.model.getSolver();
                    Move m = sl.getMove();
                    if (m == this.rfMove) {
                        sl.setMove(this.rfMove.getChildMoves().get(0));
                    } else {
                        while (m.getChildMoves() != null && m.getChildMoves().get(0) != this.rfMove) {
                            m = m.getChildMoves().get(0);
                        }
                        if (m.getChildMoves() != this.rfMove) {
                            m.setChildMoves(this.rfMove.getChildMoves());
                        }
                    }
                }
                this.restartAfterEachFail = false;
                System.arraycopy(this.mA, 0, this.A, 0, this.mA.length);
                for (int i = 0; i < this.A.length; ++i) {
                    this.vAct[i].transfer();
                }
            }
        }
    }

    private boolean checkInterval(int idx) {
        if (!this.vars[idx].isInstantiated()) {
            double stdev = Math.sqrt(this.sA[idx] / (double)(this.nb_probes - 1));
            double a = ActivityBased.distribution(this.nb_probes) * stdev / Math.sqrt(this.nb_probes);
            return a / this.mA[idx] < this.d;
        }
        return true;
    }

    private static final class MapVal
    implements IVal {
        private final TIntDoubleHashMap Av;
        private final TIntDoubleHashMap mAv;
        private final int os;

        private MapVal(int os) {
            this.os = os;
            this.Av = new TIntDoubleHashMap(32, 0.5f, 0, 0.0);
            this.mAv = new TIntDoubleHashMap(32, 0.5f, 0, 0.0);
        }

        @Override
        public double activity(int value) {
            return this.Av.get(value - this.os);
        }

        @Override
        public void setactivity(int value, double activity) {
            this.Av.put(value - this.os, activity);
        }

        @Override
        public void update(int nb_probes) {
            for (int k : this.Av.keys()) {
                double activity = this.Av.get(k);
                double oldmA = this.mAv.get(k);
                double U = activity - oldmA;
                this.mAv.adjustValue(k, U / (double)nb_probes);
            }
        }

        @Override
        public void transfer() {
            this.Av.clear();
            this.Av.putAll(this.mAv);
        }
    }

    private static final class ArrayVal
    implements IVal {
        private final double[] Av;
        private final double[] mAv;
        private final int size;
        private final int os;

        private ArrayVal(int size, int os) {
            this.size = size;
            this.os = os;
            this.Av = new double[size];
            this.mAv = new double[size];
        }

        @Override
        public double activity(int value) {
            return this.Av[value - this.os];
        }

        @Override
        public void setactivity(int value, double activity) {
            this.Av[value - this.os] = activity;
        }

        @Override
        public void update(int nb_probes) {
            int j = 0;
            while (j < this.Av.length) {
                double activity = this.Av[j];
                double oldmA = this.mAv[j];
                double U = activity - oldmA;
                int n = j++;
                this.mAv[n] = this.mAv[n] + U / (double)nb_probes;
            }
        }

        @Override
        public void transfer() {
            System.arraycopy(this.mAv, 0, this.Av, 0, this.size);
        }
    }

    private static interface IVal {
        public double activity(int var1);

        public void setactivity(int var1, double var2);

        public void update(int var1);

        public void transfer();
    }
}

