/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.strategy.selectors.values;

import org.chocosolver.solver.search.strategy.selectors.values.IntValueSelector;
import org.chocosolver.solver.variables.IntVar;

public class IntDomainMiddle
implements IntValueSelector {
    public static final boolean FLOOR = true;
    private final boolean roundingPolicy;

    public IntDomainMiddle(boolean roundingPolicy) {
        this.roundingPolicy = roundingPolicy;
    }

    @Override
    public int selectValue(IntVar var) {
        int low = var.getLB();
        int upp = var.getUB();
        double mean = (double)(low + upp) / 2.0;
        int value = this.roundingPolicy ? (int)Math.floor(mean) : (int)Math.ceil(mean);
        if (var.hasEnumeratedDomain() && !var.contains(value)) {
            double b;
            double a = var.previousValue(value);
            if (mean - a < (b = (double)var.nextValue(value)) - mean) {
                return (int)a;
            }
            if (mean - a > b - mean) {
                return (int)b;
            }
            if (this.roundingPolicy) {
                return (int)a;
            }
            return (int)b;
        }
        return value;
    }
}

