/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.strategy.decision;

import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.search.strategy.assignments.DecisionOperator;
import org.chocosolver.solver.search.strategy.decision.Decision;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.util.PoolManager;

public class SetDecision
extends Decision<SetVar> {
    private static final long serialVersionUID = -7798444054596001059L;
    private int value;
    private DecisionOperator<SetVar> operator;
    private final transient PoolManager<SetDecision> poolManager;

    public SetDecision(PoolManager<SetDecision> poolManager) {
        super(2);
        this.poolManager = poolManager;
    }

    @Override
    public Integer getDecisionValue() {
        return this.value;
    }

    @Override
    public void apply() throws ContradictionException {
        if (this.branch == 1) {
            this.operator.apply((SetVar)this.var, this.value, this);
        } else if (this.branch == 2) {
            this.operator.unapply((SetVar)this.var, this.value, this);
        }
    }

    public void set(SetVar v, int value, DecisionOperator<SetVar> operator) {
        super.set(v);
        this.var = v;
        this.value = value;
        this.operator = operator;
    }

    @Override
    public void reverse() {
        this.operator = this.operator.opposite();
    }

    @Override
    public void free() {
        this.poolManager.returnE(this);
    }

    public String toString() {
        return String.format("%s%s %s %s", this.branch < 2 ? "" : "!", ((SetVar)this.var).getName(), this.operator.toString(), this.value);
    }
}

