/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.strategy.decision;

import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.explanations.RuleStore;
import org.chocosolver.solver.search.strategy.assignments.DecisionOperator;
import org.chocosolver.solver.search.strategy.assignments.DecisionOperatorFactory;
import org.chocosolver.solver.search.strategy.decision.Decision;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.events.IEventType;
import org.chocosolver.util.PoolManager;

public class IntDecision
extends Decision<IntVar> {
    private static final long serialVersionUID = 4319290465131546449L;
    private int value;
    private DecisionOperator<IntVar> assignment;
    private final transient PoolManager<IntDecision> poolManager;

    public IntDecision(PoolManager<IntDecision> poolManager) {
        super(2);
        this.poolManager = poolManager;
    }

    @Override
    public Integer getDecisionValue() {
        return this.value;
    }

    @Override
    public void apply() throws ContradictionException {
        if (this.branch == 1) {
            this.assignment.apply((IntVar)this.var, this.value, this);
        } else if (this.branch == 2) {
            this.assignment.unapply((IntVar)this.var, this.value, this);
        }
    }

    public void set(IntVar v, int value, DecisionOperator<IntVar> assignment) {
        super.set(v);
        this.value = value;
        this.assignment = assignment;
    }

    @Override
    public void reverse() {
        this.assignment = this.assignment.opposite();
    }

    @Override
    public void free() {
        this.poolManager.returnE(this);
    }

    public IntDecision duplicate() {
        IntDecision d = this.poolManager.getE();
        if (d == null) {
            d = new IntDecision(this.poolManager);
        }
        d.set((IntVar)this.var, this.value, this.assignment);
        return d;
    }

    @Override
    public boolean isEquivalentTo(Decision dec) {
        if (dec instanceof IntDecision) {
            IntDecision id = (IntDecision)dec;
            return id.var == this.var && id.assignment == this.assignment && id.value == this.value && id.max_branching == this.max_branching && id.branch == this.branch;
        }
        return false;
    }

    public DecisionOperator<IntVar> getDecOp() {
        return this.assignment;
    }

    public IntDecision flip() {
        IntDecision d = this.poolManager.getE();
        if (d == null) {
            d = new IntDecision(this.poolManager);
        }
        int val = this.value;
        if (this.assignment == DecisionOperatorFactory.makeIntSplit()) {
            ++val;
        } else if (this.assignment == DecisionOperatorFactory.makeIntReverseSplit()) {
            --val;
        }
        d.set((IntVar)this.var, val, this.assignment.opposite());
        return d;
    }

    public String toString() {
        if (this.assignment.equals(DecisionOperatorFactory.makeIntEq())) {
            return String.format("%s %s {%d}", ((IntVar)this.var).getName(), this.branch < 1 ? "=" : Character.valueOf('\\'), this.value);
        }
        if (this.assignment.equals(DecisionOperatorFactory.makeIntNeq())) {
            return String.format("%s %s {%d}", ((IntVar)this.var).getName(), this.branch < 1 ? Character.valueOf('\\') : "=", this.value);
        }
        if (this.assignment.equals(DecisionOperatorFactory.makeIntSplit())) {
            return String.format("%s in %s%d,%d]", ((IntVar)this.var).getName(), Character.valueOf(this.branch < 1 ? (char)'[' : ']'), this.branch < 1 ? ((IntVar)this.var).getLB() : this.value, this.branch < 1 ? this.value : ((IntVar)this.var).getUB());
        }
        if (this.assignment.equals(DecisionOperatorFactory.makeIntReverseSplit())) {
            return String.format("%s in [%d,%d%s", ((IntVar)this.var).getName(), this.branch < 1 ? this.value : ((IntVar)this.var).getLB(), this.branch < 1 ? ((IntVar)this.var).getUB() : this.value, Character.valueOf(this.branch < 1 ? (char)']' : '['));
        }
        return String.format("%s %s {%s}", ((IntVar)this.var).getName(), this.branch < 1 ? this.assignment.toString() : this.assignment.opposite().toString(), this.value);
    }

    @Override
    public boolean why(RuleStore ruleStore, IntVar var, IEventType evt, int value) {
        return false;
    }
}

