/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.strategy.decision;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.chocosolver.memory.IEnvironment;
import org.chocosolver.memory.IStateInt;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.search.strategy.decision.Decision;
import org.chocosolver.solver.search.strategy.decision.DecisionMaker;
import org.chocosolver.solver.search.strategy.decision.RootDecision;

public class DecisionPath
extends DecisionMaker
implements Serializable {
    private List<Decision> decisions = new ArrayList<Decision>();
    protected IStateInt mLevel;
    protected int[] levels;

    public DecisionPath(IEnvironment environment) {
        this.mLevel = environment.makeInt(0);
        this.decisions.add(RootDecision.ROOT);
        this.levels = new int[10];
        this.levels[0] = 1;
    }

    public void apply() throws ContradictionException {
        int t;
        int l = this.mLevel.get();
        int f = this.levels[l];
        boolean samelevel = f < (t = this.decisions.size()) - 1;
        for (int i = f; i < t; ++i) {
            Decision decision = this.decisions.get(i);
            if (samelevel) {
                decision.setRefutable(false);
            }
            decision.buildNext();
            decision.apply();
        }
        if (t - f > 0) {
            this.mLevel.add(1);
            this.ensureCapacity(l + 1);
            this.levels[l + 1] = this.decisions.size();
        }
    }

    private void ensureCapacity(int ncapa) {
        if (this.levels.length <= ncapa) {
            int[] tmp = this.levels;
            this.levels = new int[ncapa * 3 / 2 + 1];
            System.arraycopy(tmp, 0, this.levels, 0, tmp.length);
        }
    }

    public void pushDecision(Decision decision) {
        decision.setPosition(this.decisions.size());
        this.decisions.add(decision);
    }

    public void synchronize() {
        if (this.decisions.size() > 1) {
            int t = this.levels[this.mLevel.get()];
            for (int f = this.decisions.size() - 1; f >= t; --f) {
                this.decisions.remove(f).free();
            }
        }
    }

    public Decision getLastDecision() {
        int size = this.decisions.size();
        return this.decisions.get(size - 1);
    }

    public int indexPreviousLevelLastLevel() {
        return this.levels[this.mLevel.get()];
    }

    public int size() {
        return this.decisions.size();
    }

    public Decision getDecision(int i) {
        if (i < 0 || i >= this.decisions.size()) {
            throw new IndexOutOfBoundsException("Index: " + i + ", Size: " + this.decisions.size());
        }
        return this.decisions.get(i);
    }

    public void transferInto(Collection<Decision> aList, boolean includeRootDecision) {
        int i;
        int n = i = includeRootDecision ? 0 : 1;
        while (i < this.decisions.size()) {
            aList.add(this.decisions.get(i));
            ++i;
        }
    }

    public String lastDecisionToString() {
        int t;
        StringBuilder st = new StringBuilder();
        int l = this.mLevel.get();
        int f = this.levels[l];
        if (f < (t = this.decisions.size()) - 1) {
            st.append("[1/1] ");
            Decision decision = this.decisions.get(f);
            st.append(decision.toString());
            for (int i = f + 1; i < t; ++i) {
                decision = this.decisions.get(i);
                st.append(" /\\ ").append(decision.toString());
            }
        } else if (f < t) {
            Decision decision = this.decisions.get(f);
            st.append(String.format("[%d/%d] %s", decision.getArity() - decision.triesLeft() + 1, decision.getArity(), decision.toString()));
        }
        return st.toString();
    }
}

