/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.strategy.assignments;

import org.chocosolver.solver.ICause;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.search.strategy.assignments.DecisionOperator;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.SetVar;

public final class DecisionOperatorFactory {
    private DecisionOperatorFactory() {
    }

    public static DecisionOperator<IntVar> makeIntEq() {
        return IntEqDecision.getInstance();
    }

    public static DecisionOperator<IntVar> makeIntNeq() {
        return IntNeqDecision.getInstance();
    }

    public static DecisionOperator<IntVar> makeIntSplit() {
        return IntSplitDecision.getInstance();
    }

    public static DecisionOperator<IntVar> makeIntReverseSplit() {
        return IntReverseSplitDecision.getInstance();
    }

    public static DecisionOperator<SetVar> makeSetForce() {
        return SetForceDecision.getInstance();
    }

    public static DecisionOperator<SetVar> makeSetRemove() {
        return SetRemoveDecision.getInstance();
    }

    private static final class SetRemoveDecision
    implements DecisionOperator<SetVar> {
        private static final long serialVersionUID = -580239209082758455L;
        private static final SetRemoveDecision INSTANCE = new SetRemoveDecision();

        public static final SetRemoveDecision getInstance() {
            return INSTANCE;
        }

        private SetRemoveDecision() {
        }

        private Object readResolve() {
            return INSTANCE;
        }

        @Override
        public void apply(SetVar var, int element, ICause cause) throws ContradictionException {
            var.remove(element, cause);
        }

        @Override
        public void unapply(SetVar var, int element, ICause cause) throws ContradictionException {
            var.force(element, cause);
        }

        @Override
        public String toString() {
            return " !contains ";
        }

        @Override
        public DecisionOperator<SetVar> opposite() {
            return DecisionOperatorFactory.makeSetForce();
        }
    }

    private static final class SetForceDecision
    implements DecisionOperator<SetVar> {
        private static final long serialVersionUID = -4868225105307378160L;
        private static final SetForceDecision INSTANCE = new SetForceDecision();

        public static final SetForceDecision getInstance() {
            return INSTANCE;
        }

        private SetForceDecision() {
        }

        private Object readResolve() {
            return INSTANCE;
        }

        @Override
        public void apply(SetVar var, int element, ICause cause) throws ContradictionException {
            var.force(element, cause);
        }

        @Override
        public void unapply(SetVar var, int element, ICause cause) throws ContradictionException {
            var.remove(element, cause);
        }

        @Override
        public String toString() {
            return " contains ";
        }

        @Override
        public DecisionOperator<SetVar> opposite() {
            return DecisionOperatorFactory.makeSetRemove();
        }
    }

    private static final class IntReverseSplitDecision
    implements DecisionOperator<IntVar> {
        private static final long serialVersionUID = -4155926684198463505L;
        private static final IntReverseSplitDecision INSTANCE = new IntReverseSplitDecision();

        public static final IntReverseSplitDecision getInstance() {
            return INSTANCE;
        }

        private IntReverseSplitDecision() {
        }

        private Object readResolve() {
            return INSTANCE;
        }

        @Override
        public void apply(IntVar var, int value, ICause cause) throws ContradictionException {
            var.updateLowerBound(value, cause);
        }

        @Override
        public void unapply(IntVar var, int value, ICause cause) throws ContradictionException {
            var.updateUpperBound(value - 1, cause);
        }

        @Override
        public String toString() {
            return " >= ";
        }

        @Override
        public DecisionOperator<IntVar> opposite() {
            return DecisionOperatorFactory.makeIntSplit();
        }
    }

    private static final class IntSplitDecision
    implements DecisionOperator<IntVar> {
        private static final long serialVersionUID = 2796498653106384502L;
        private static final IntSplitDecision INSTANCE = new IntSplitDecision();

        public static final IntSplitDecision getInstance() {
            return INSTANCE;
        }

        private IntSplitDecision() {
        }

        @Override
        public void apply(IntVar var, int value, ICause cause) throws ContradictionException {
            var.updateUpperBound(value, cause);
        }

        @Override
        public void unapply(IntVar var, int value, ICause cause) throws ContradictionException {
            var.updateLowerBound(value + 1, cause);
        }

        @Override
        public String toString() {
            return " <= ";
        }

        @Override
        public DecisionOperator<IntVar> opposite() {
            return DecisionOperatorFactory.makeIntReverseSplit();
        }
    }

    private static final class IntNeqDecision
    implements DecisionOperator<IntVar> {
        private static final long serialVersionUID = 3056222234436601667L;
        private static final IntNeqDecision INSTANCE = new IntNeqDecision();

        private IntNeqDecision() {
        }

        public static final IntNeqDecision getInstance() {
            return INSTANCE;
        }

        private Object readResolve() {
            return INSTANCE;
        }

        @Override
        public void apply(IntVar var, int value, ICause cause) throws ContradictionException {
            var.removeValue(value, cause);
        }

        @Override
        public void unapply(IntVar var, int value, ICause cause) throws ContradictionException {
            var.instantiateTo(value, cause);
        }

        @Override
        public String toString() {
            return " != ";
        }

        @Override
        public DecisionOperator<IntVar> opposite() {
            return DecisionOperatorFactory.makeIntEq();
        }
    }

    private static final class IntEqDecision
    implements DecisionOperator<IntVar> {
        private static final long serialVersionUID = 7293773317776136982L;
        private static final IntEqDecision INSTANCE = new IntEqDecision();

        private IntEqDecision() {
        }

        public static final IntEqDecision getInstance() {
            return INSTANCE;
        }

        private Object readResolve() {
            return INSTANCE;
        }

        @Override
        public void apply(IntVar var, int value, ICause cause) throws ContradictionException {
            var.instantiateTo(value, cause);
        }

        @Override
        public void unapply(IntVar var, int value, ICause cause) throws ContradictionException {
            var.removeValue(value, cause);
        }

        @Override
        public String toString() {
            return " == ";
        }

        @Override
        public DecisionOperator<IntVar> opposite() {
            return DecisionOperatorFactory.makeIntNeq();
        }
    }
}

