/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.strategy;

import java.util.ArrayList;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.ResolutionPolicy;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.search.strategy.BoundSearch;
import org.chocosolver.solver.search.strategy.assignments.DecisionOperator;
import org.chocosolver.solver.search.strategy.assignments.DecisionOperatorFactory;
import org.chocosolver.solver.search.strategy.selectors.values.IntDomainMax;
import org.chocosolver.solver.search.strategy.selectors.values.IntDomainMin;
import org.chocosolver.solver.search.strategy.selectors.values.IntDomainRandom;
import org.chocosolver.solver.search.strategy.selectors.values.IntDomainRandomBound;
import org.chocosolver.solver.search.strategy.selectors.values.IntValueSelector;
import org.chocosolver.solver.search.strategy.selectors.values.RealDomainMax;
import org.chocosolver.solver.search.strategy.selectors.values.RealDomainMiddle;
import org.chocosolver.solver.search.strategy.selectors.values.RealDomainMin;
import org.chocosolver.solver.search.strategy.selectors.values.RealValueSelector;
import org.chocosolver.solver.search.strategy.selectors.values.SetDomainMin;
import org.chocosolver.solver.search.strategy.selectors.values.SetValueSelector;
import org.chocosolver.solver.search.strategy.selectors.variables.ActivityBased;
import org.chocosolver.solver.search.strategy.selectors.variables.Cyclic;
import org.chocosolver.solver.search.strategy.selectors.variables.DomOverWDeg;
import org.chocosolver.solver.search.strategy.selectors.variables.FirstFail;
import org.chocosolver.solver.search.strategy.selectors.variables.GeneralizedMinDomVarSelector;
import org.chocosolver.solver.search.strategy.selectors.variables.InputOrder;
import org.chocosolver.solver.search.strategy.selectors.variables.Random;
import org.chocosolver.solver.search.strategy.selectors.variables.VariableSelector;
import org.chocosolver.solver.search.strategy.strategy.AbstractStrategy;
import org.chocosolver.solver.search.strategy.strategy.ConflictOrderingSearch;
import org.chocosolver.solver.search.strategy.strategy.GreedyBranching;
import org.chocosolver.solver.search.strategy.strategy.IntStrategy;
import org.chocosolver.solver.search.strategy.strategy.LastConflict;
import org.chocosolver.solver.search.strategy.strategy.RealStrategy;
import org.chocosolver.solver.search.strategy.strategy.SetStrategy;
import org.chocosolver.solver.search.strategy.strategy.StrategiesSequencer;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.RealVar;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.solver.variables.Variable;

public class Search {
    public static AbstractStrategy lastConflict(AbstractStrategy formerSearch) {
        return Search.lastConflict(formerSearch, 1);
    }

    public static AbstractStrategy<IntVar> bestBound(AbstractStrategy formerSearch) {
        if (formerSearch == null) {
            throw new UnsupportedOperationException("the search strategy in parameter cannot be null! Consider using Search.defaultSearch(model)");
        }
        return new BoundSearch(formerSearch);
    }

    public static AbstractStrategy lastConflict(AbstractStrategy formerSearch, int k) {
        if (formerSearch == null) {
            throw new UnsupportedOperationException("the search strategy in parameter cannot be null! Consider using Search.defaultSearch(model)");
        }
        return new LastConflict(formerSearch.getVariables()[0].getModel(), formerSearch, k);
    }

    public static AbstractStrategy conflictOrderingSearch(AbstractStrategy formerSearch) {
        return new ConflictOrderingSearch(formerSearch.getVariables()[0].getModel(), formerSearch);
    }

    public static AbstractStrategy greedySearch(AbstractStrategy search) {
        return new GreedyBranching(search);
    }

    public static AbstractStrategy sequencer(AbstractStrategy ... searches) {
        return new StrategiesSequencer(searches);
    }

    public static SetStrategy setVarSearch(VariableSelector<SetVar> varS, SetValueSelector valS, boolean enforceFirst, SetVar ... sets) {
        return new SetStrategy(sets, varS, valS, enforceFirst);
    }

    public static SetStrategy setVarSearch(SetVar ... sets) {
        return Search.setVarSearch(new GeneralizedMinDomVarSelector(), new SetDomainMin(), true, sets);
    }

    public static RealStrategy realVarSearch(VariableSelector<RealVar> varS, RealValueSelector valS, RealVar ... rvars) {
        return new RealStrategy(rvars, varS, valS);
    }

    public static RealStrategy realVarSearch(RealVar ... reals) {
        return Search.realVarSearch(new Cyclic<RealVar>(), new RealDomainMiddle(), reals);
    }

    public static IntStrategy intVarSearch(VariableSelector<IntVar> varSelector, IntValueSelector valSelector, DecisionOperator<IntVar> decisionOperator, IntVar ... vars) {
        return new IntStrategy(vars, varSelector, valSelector, decisionOperator);
    }

    public static IntStrategy intVarSearch(VariableSelector<IntVar> varSelector, IntValueSelector valSelector, IntVar ... vars) {
        return Search.intVarSearch(varSelector, valSelector, DecisionOperatorFactory.makeIntEq(), vars);
    }

    public static AbstractStrategy<IntVar> intVarSearch(IntVar ... vars) {
        final boolean satOrMin = vars[0].getModel().getResolutionPolicy() != ResolutionPolicy.MAXIMIZE;
        IntValueSelector valSel = new IntValueSelector(){

            @Override
            public int selectValue(IntVar var) {
                if (var.isBool() || !satOrMin) {
                    return var.getUB();
                }
                return var.getLB();
            }
        };
        return new DomOverWDeg(vars, 0L, valSel);
    }

    public static AbstractStrategy<IntVar> domOverWDegSearch(IntVar ... vars) {
        return new DomOverWDeg(vars, 0L, new IntDomainMin());
    }

    public static AbstractStrategy<IntVar> activityBasedSearch(IntVar ... vars) {
        return new ActivityBased(vars);
    }

    public static IntStrategy randomSearch(IntVar[] vars, long seed) {
        IntDomainRandom value = new IntDomainRandom(seed);
        IntDomainRandomBound bound = new IntDomainRandomBound(seed);
        IntValueSelector selector = var -> {
            if (var.hasEnumeratedDomain()) {
                return value.selectValue(var);
            }
            return bound.selectValue(var);
        };
        return Search.intVarSearch(new Random<IntVar>(seed), selector, vars);
    }

    public static IntStrategy inputOrderLBSearch(IntVar ... vars) {
        return Search.intVarSearch(new InputOrder<IntVar>(vars[0].getModel()), (IntValueSelector)new IntDomainMin(), vars);
    }

    public static IntStrategy inputOrderUBSearch(IntVar ... vars) {
        return Search.intVarSearch(new InputOrder<IntVar>(vars[0].getModel()), (IntValueSelector)new IntDomainMax(), vars);
    }

    public static IntStrategy minDomLBSearch(IntVar ... vars) {
        return Search.intVarSearch((VariableSelector<IntVar>)new FirstFail(vars[0].getModel()), (IntValueSelector)new IntDomainMin(), vars);
    }

    public static IntStrategy minDomUBSearch(IntVar ... vars) {
        return Search.intVarSearch((VariableSelector<IntVar>)new FirstFail(vars[0].getModel()), (IntValueSelector)new IntDomainMax(), vars);
    }

    public static AbstractStrategy defaultSearch(Model model) {
        Solver r = model.getSolver();
        ArrayList<IntVar> livars = new ArrayList<IntVar>();
        ArrayList<SetVar> lsvars = new ArrayList<SetVar>();
        ArrayList<RealVar> lrvars = new ArrayList<RealVar>();
        Variable[] variables = model.getVars();
        Variable objective = null;
        block5: for (Variable var : variables) {
            int type = var.getTypeAndKind();
            if ((type & 2) != 0) continue;
            int kind = type & 0x3F8;
            switch (kind) {
                case 8: 
                case 24: {
                    livars.add((IntVar)var);
                    continue block5;
                }
                case 32: {
                    lsvars.add((SetVar)var);
                    continue block5;
                }
                case 64: {
                    lrvars.add((RealVar)var);
                    continue block5;
                }
            }
        }
        if (r.getObjectiveManager().isOptimization()) {
            objective = (Variable)r.getObjectiveManager().getObjective();
            if ((objective.getTypeAndKind() & 0x40) != 0) {
                lrvars.remove(objective);
            } else {
                assert ((objective.getTypeAndKind() & 8) != 0);
                livars.remove(objective);
            }
        }
        ArrayList<AbstractStrategy<IntVar>> strats = new ArrayList<AbstractStrategy<IntVar>>();
        if (livars.size() > 0) {
            strats.add(Search.intVarSearch(livars.toArray(new IntVar[livars.size()])));
        }
        if (lsvars.size() > 0) {
            strats.add(Search.setVarSearch(lsvars.toArray(new SetVar[lsvars.size()])));
        }
        if (lrvars.size() > 0) {
            strats.add(Search.realVarSearch(lrvars.toArray(new RealVar[lrvars.size()])));
        }
        if (objective != null) {
            boolean max;
            boolean bl = max = r.getObjectiveManager().getPolicy() == ResolutionPolicy.MAXIMIZE;
            if ((objective.getTypeAndKind() & 0x40) != 0) {
                strats.add(Search.realVarSearch(new Cyclic<RealVar>(), max ? new RealDomainMax() : new RealDomainMin(), (RealVar)objective));
            } else {
                strats.add(max ? Search.minDomUBSearch((IntVar)objective) : Search.minDomLBSearch((IntVar)objective));
            }
        }
        if (strats.isEmpty()) {
            strats.add(Search.minDomLBSearch(model.boolVar(true)));
        }
        return Search.lastConflict(Search.sequencer(strats.toArray(new AbstractStrategy[strats.size()])));
    }
}

