/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.strategy;

import gnu.trove.map.hash.TIntIntHashMap;
import java.util.Random;
import org.chocosolver.solver.Cause;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.ResolutionPolicy;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.search.strategy.assignments.DecisionOperatorFactory;
import org.chocosolver.solver.search.strategy.decision.Decision;
import org.chocosolver.solver.search.strategy.decision.DecisionPath;
import org.chocosolver.solver.search.strategy.decision.IntDecision;
import org.chocosolver.solver.search.strategy.strategy.AbstractStrategy;
import org.chocosolver.solver.variables.IntVar;

public class BoundSearch
extends AbstractStrategy {
    private final Model model;
    private final DecisionPath decisionPath;
    private AbstractStrategy definedSearch;
    private TIntIntHashMap vb = new TIntIntHashMap();
    private IntVar variable;
    private Random rd = new Random(0L);
    public int MAX_DOM_SIZE = 100;

    public BoundSearch(AbstractStrategy mainSearch) {
        super(mainSearch.getVariables());
        this.model = this.vars[0].getModel();
        this.definedSearch = mainSearch;
        this.decisionPath = this.model.getSolver().getDecisionPath();
    }

    public Decision getDecision() {
        if (this.variable == null || this.variable.isInstantiated()) {
            Decision d = this.definedSearch.getDecision();
            this.vb.clear();
            if (d == null) {
                return null;
            }
            if ((d.getDecisionVariable().getTypeAndKind() & 8) != 0) {
                this.variable = (IntVar)d.getDecisionVariable();
            } else {
                return d;
            }
        }
        if (this.variable.getDomainSize() < this.MAX_DOM_SIZE) {
            if (this.variable.hasEnumeratedDomain()) {
                this.vb.clear();
                int v = this.variable.getLB();
                while (v <= this.variable.getUB()) {
                    int bound = this.bound(v);
                    if (bound == Integer.MAX_VALUE) {
                        return this.removeVal(v);
                    }
                    this.vb.put(v, bound);
                    v = this.variable.nextValue(v);
                }
                return this.decisionPath.makeIntDecision(this.variable, DecisionOperatorFactory.makeIntEq(), this.getBestVal());
            }
            this.vb.clear();
            int lbB = this.bound(this.variable.getLB());
            int ubB = this.bound(this.variable.getUB());
            if (lbB == Integer.MAX_VALUE && ubB == Integer.MAX_VALUE) {
                return this.removeVal(this.rd.nextBoolean() ? this.variable.getLB() : this.variable.getUB());
            }
            return this.decisionPath.makeIntDecision(this.variable, DecisionOperatorFactory.makeIntEq(), Math.min(lbB, ubB));
        }
        this.vb.clear();
        return this.definedSearch.getDecision();
    }

    private IntDecision removeVal(int val) {
        IntDecision d = this.decisionPath.makeIntDecision(this.variable, DecisionOperatorFactory.makeIntNeq(), val);
        d.setRefutable(false);
        return d;
    }

    private int bound(int val) {
        int cost;
        this.model.getEnvironment().worldPush();
        try {
            this.variable.instantiateTo(val, Cause.Null);
            this.model.getSolver().getEngine().propagate();
            ResolutionPolicy rp = this.model.getSolver().getObjectiveManager().getPolicy();
            cost = rp == ResolutionPolicy.SATISFACTION ? 1 : (rp == ResolutionPolicy.MINIMIZE ? ((IntVar)this.model.getObjective()).getLB() : -((IntVar)this.model.getObjective()).getUB());
        }
        catch (ContradictionException cex) {
            cost = Integer.MAX_VALUE;
        }
        this.model.getSolver().getEngine().flush();
        this.model.getEnvironment().worldPop();
        return cost;
    }

    public int getBestVal() {
        int coef = 1;
        if (this.variable.hasEnumeratedDomain()) {
            int bestCost = Integer.MAX_VALUE;
            int bestV = this.variable.getUB();
            int v = this.variable.getLB();
            while (v <= this.variable.getUB()) {
                int c = this.vb.get(v);
                if (c < bestCost * coef) {
                    bestCost = c;
                    bestV = v;
                }
                v = this.variable.nextValue(v);
            }
            return bestV;
        }
        return this.bound(this.variable.getLB()) < this.bound(this.variable.getUB()) * coef ? this.variable.getLB() : this.variable.getUB();
    }
}

