/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.measure;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Objects;
import java.util.function.LongSupplier;
import org.chocosolver.solver.objective.IBoundsManager;
import org.chocosolver.solver.search.SearchState;
import org.chocosolver.solver.search.measure.Measures;

public final class MeasuresRecorder
extends Measures {
    private static final long serialVersionUID = -2027525308178413040L;
    private long startingTime;
    private transient LongSupplier currentNanoTime = () -> this.timeCount;

    public MeasuresRecorder(String modelName) {
        super(modelName);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.getTimeCountInNanoSeconds();
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.currentNanoTime = () -> this.timeCount;
    }

    @Override
    public long getTimeCountInNanoSeconds() {
        this.timeCount = this.currentNanoTime.getAsLong();
        return super.getTimeCountInNanoSeconds();
    }

    public void startStopwatch() {
        this.startingTime = System.nanoTime();
        this.currentNanoTime = () -> System.nanoTime() - this.startingTime;
    }

    public void stopStopwatch() {
        this.timeCount = this.currentNanoTime.getAsLong();
        this.currentNanoTime = () -> this.timeCount;
    }

    public final void setObjectiveOptimal(boolean objectiveOptimal) {
        this.objectiveOptimal = objectiveOptimal;
    }

    public void reset() {
        this.state = SearchState.NEW;
        this.objectiveOptimal = false;
        this.solutionCount = 0L;
        this.timeCount = 0L;
        this.stopStopwatch();
        this.nodeCount = 0L;
        this.backtrackCount = 0L;
        this.failCount = 0L;
        this.restartCount = 0L;
        this.depth = 0L;
        this.maxDepth = 0L;
    }

    public final void incNodeCount() {
        ++this.nodeCount;
        if (this.depth > this.maxDepth) {
            this.maxDepth = this.depth;
        }
    }

    public final void incBackTrackCount() {
        ++this.backtrackCount;
    }

    public final void incFailCount() {
        ++this.failCount;
    }

    public final void incRestartCount() {
        ++this.restartCount;
    }

    public final void incSolutionCount() {
        ++this.solutionCount;
    }

    public final void incDepth() {
        ++this.depth;
    }

    public final void decDepth() {
        --this.depth;
    }

    public final void setSearchState(SearchState state) {
        Objects.requireNonNull(state);
        this.state = state;
    }

    public final void setBoundsManager(IBoundsManager boundsManager) {
        Objects.requireNonNull(boundsManager);
        this.boundsManager = boundsManager;
    }

    public final void setTimeCount(long timeCount) {
        this.timeCount = timeCount;
    }

    public final void setReadingTimeCount(long readingTimeCount) {
        this.readingTimeCount = readingTimeCount;
    }
}

