/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.loop.move;

import java.util.Arrays;
import java.util.List;
import org.chocosolver.memory.IStateInt;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.search.loop.move.Move;
import org.chocosolver.solver.search.strategy.strategy.AbstractStrategy;
import org.chocosolver.solver.search.strategy.strategy.StrategiesSequencer;
import org.chocosolver.solver.variables.Variable;

public class MoveSeq
implements Move {
    private List<Move> moves;
    private IStateInt index;
    private AbstractStrategy seqStrat;

    public MoveSeq(Model model, Move ... moves) {
        this.moves = Arrays.asList(moves);
        this.index = model.getEnvironment().makeInt(0);
        AbstractStrategy[] strats = new AbstractStrategy[moves.length];
        for (int i = 0; i < moves.length; ++i) {
            strats[i] = moves[i].getStrategy();
        }
        this.seqStrat = new StrategiesSequencer(strats);
    }

    @Override
    public boolean init() {
        boolean init = true;
        for (int i = 0; i < this.moves.size() && init; ++i) {
            init = this.moves.get(i).init();
        }
        return init;
    }

    @Override
    public boolean extend(Solver solver) {
        boolean extend = false;
        int i = this.index.get();
        if (i < this.moves.size()) {
            extend = this.moves.get(i).extend(solver);
        }
        while (i < this.moves.size() - 1 && !extend) {
            this.moves.get(++i).setTopDecisionPosition(solver.getDecisionPath().size());
            extend = this.moves.get(i).extend(solver);
        }
        this.index.set(i);
        return extend;
    }

    @Override
    public boolean repair(Solver solver) {
        boolean repair = false;
        int i = this.index.get() + 1;
        while (i > 0 && !repair) {
            repair = this.moves.get(--i).repair(solver);
            if (i <= 0) continue;
            solver.getDecisionPath().synchronize();
        }
        this.index.set(i);
        return repair;
    }

    @Override
    public void setTopDecisionPosition(int position) {
        for (int i = 0; i < this.moves.size(); ++i) {
            this.moves.get(i).setTopDecisionPosition(position);
        }
    }

    @Override
    public <V extends Variable> AbstractStrategy<V> getStrategy() {
        return this.seqStrat;
    }

    @Override
    public <V extends Variable> void setStrategy(AbstractStrategy<V> aStrategy) {
        throw new UnsupportedOperationException("A sequential Move does not support declaring search strategy in retrospect.\nIt has to be done on each of it child nodes.");
    }

    @Override
    public List<Move> getChildMoves() {
        return this.moves;
    }

    @Override
    public void setChildMoves(List<Move> someMoves) {
        this.moves = someMoves;
    }
}

