/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.loop.move;

import gnu.trove.map.TObjectDoubleMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.map.hash.TObjectDoubleHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TreeMap;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.explanations.Explanation;
import org.chocosolver.solver.search.loop.learn.LearnExplained;
import org.chocosolver.solver.search.loop.move.Move;
import org.chocosolver.solver.search.strategy.assignments.DecisionOperator;
import org.chocosolver.solver.search.strategy.decision.Decision;
import org.chocosolver.solver.search.strategy.decision.DecisionPath;
import org.chocosolver.solver.search.strategy.decision.IntDecision;
import org.chocosolver.solver.search.strategy.strategy.AbstractStrategy;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;

public class MoveLearnBinaryTDR
extends LearnExplained
implements Move {
    private static final boolean DEBUG = true;
    private final Move move;
    private List<List<IntDecision>> gamma;
    private int s;
    private IntDecision[] neighbor;
    private int current;
    private TIntObjectHashMap<TIntObjectHashMap<TObjectDoubleMap<DecisionOperator>>> weights;
    private TreeMap<Integer, Double> L;
    private boolean stop = false;

    private MoveLearnBinaryTDR(Model aModel, Move move, int tabuListSize) {
        super(aModel, false, false);
        this.move = move;
        this.s = tabuListSize;
        this.gamma = new ArrayList<List<IntDecision>>();
        this.weights = new TIntObjectHashMap(16, 0.5f, -1);
        this.neighbor = new IntDecision[0];
        this.current = 0;
        this.L = new TreeMap();
    }

    @Override
    public boolean extend(Solver solver) {
        boolean extend;
        if (this.current < this.neighbor.length) {
            DecisionPath dp = solver.getDecisionPath();
            assert (this.neighbor[this.current] != null);
            dp.pushDecision(this.neighbor[this.current++]);
            solver.getEnvironment().worldPush();
            extend = true;
        } else {
            extend = this.move.extend(solver);
        }
        return extend;
    }

    @Override
    public boolean repair(Solver solver) {
        boolean repair;
        if (this.current < this.neighbor.length) {
            solver.restart();
            repair = !this.stop;
        } else {
            repair = this.move.repair(solver);
        }
        return repair;
    }

    @Override
    public void onFailure(Solver solver) {
        super.onFailure(solver);
        this.neighbor(solver);
    }

    private void neighbor(Solver solver) {
        boolean compatible;
        Explanation expl = this.getLastExplanation();
        List<IntDecision> k = this.extractConlict(solver, expl);
        this.gamma.add(k);
        if (this.gamma.size() > this.s) {
            List<IntDecision> r = this.gamma.remove(0);
            this.decWeight(r);
        }
        System.out.printf("G:\n", new Object[0]);
        for (List list : this.gamma) {
            System.out.printf("\t", new Object[0]);
            for (int i = list.size() - 1; i > -1; --i) {
                IntDecision d = (IntDecision)list.get(i);
                System.out.printf("%s %s %d, ", ((IntVar)d.getDecisionVariable()).getName(), d.getDecOp(), d.getDecisionValue());
            }
            System.out.printf("\n", new Object[0]);
        }
        System.out.printf("CD:\n", new Object[0]);
        do {
            int n = this.L.lastKey();
            IntDecision d = this.neighbor[n].flip();
            this.neighbor[n].free();
            this.neighbor[n] = d;
            System.out.printf("\t%s ? \n", Arrays.toString(this.neighbor));
            compatible = this.isCDcompatible();
            if (!compatible) {
                d = this.neighbor[n].flip();
                this.neighbor[n].free();
                this.neighbor[n] = d;
            }
            this.L.remove(n);
        } while (!compatible && !this.L.isEmpty());
        System.out.printf("%s\n", compatible);
        this.stop = !compatible;
    }

    private boolean isCDcompatible() {
        boolean compatible = true;
        for (int i = 0; i < this.gamma.size() - 1 && compatible; ++i) {
            if (!this.isSubsetOfNeighbor(this.gamma.get(i))) continue;
            compatible = false;
        }
        return compatible;
    }

    private boolean isSubsetOfNeighbor(List<IntDecision> conflict) {
        boolean subset = true;
        for (int j = 0; j < conflict.size() && subset; ++j) {
            IntVar var = (IntVar)conflict.get(j).getDecisionVariable();
            int val = conflict.get(j).getDecisionValue();
            DecisionOperator<IntVar> dop = conflict.get(j).getDecOp();
            boolean contains = false;
            for (int k = 0; k < this.neighbor.length && !contains; ++k) {
                contains = dop == this.neighbor[k].getDecOp() && var == this.neighbor[k].getDecisionVariable() && val == this.neighbor[k].getDecisionValue();
            }
            subset = contains;
        }
        return subset;
    }

    private void incWeight(List<IntDecision> k, int i, double w) {
        TObjectDoubleMap<DecisionOperator> _w2;
        TIntObjectHashMap<TObjectDoubleMap<DecisionOperator<TObjectDoubleMap<DecisionOperator>>>> _w1 = this.weights.get(((IntVar)k.get(i).getDecisionVariable()).getId());
        if (_w1 == null) {
            _w1 = new TIntObjectHashMap(10, 0.5f, Integer.MAX_VALUE);
            this.weights.put(((IntVar)k.get(i).getDecisionVariable()).getId(), _w1);
        }
        if ((_w2 = _w1.get(k.get(i).getDecisionValue())) == null) {
            _w2 = new TObjectDoubleHashMap<DecisionOperator>(10, 0.5f, 0.0);
            _w1.put(k.get(i).getDecisionValue(), _w2);
        }
        _w2.adjustOrPutValue(k.get(i).getDecOp(), w, w);
    }

    private void decWeight(List<IntDecision> k) {
        int size = k.size();
        double w = -1.0 / (double)size;
        for (int i = 0; i < size; ++i) {
            TIntObjectHashMap<TObjectDoubleMap<DecisionOperator>> _w1 = this.weights.get(((IntVar)k.get(i).getDecisionVariable()).getId());
            TObjectDoubleMap<DecisionOperator> _w2 = _w1.get(k.get(i).getDecisionValue());
            _w2.adjustValue(k.get(i).getDecOp(), w);
        }
    }

    private double getWeight(List<IntDecision> k, int i) {
        TIntObjectHashMap<TObjectDoubleMap<DecisionOperator>> _w1 = this.weights.get(((IntVar)k.get(i).getDecisionVariable()).getId());
        TObjectDoubleMap<DecisionOperator> _w2 = _w1.get(k.get(i).getDecisionValue());
        return _w2.get(k.get(i).getDecOp());
    }

    private List<IntDecision> extractConlict(Solver solver, Explanation lastExplanation) {
        int offset = solver.getSearchWorldIndex();
        int wi = solver.getEnvironment().getWorldIndex() - 1;
        int k = wi - offset;
        int size = lastExplanation.getDecisions().cardinality();
        double w = 1.0 / (double)size;
        this.current = 0;
        this.neighbor = new IntDecision[k];
        this.L.clear();
        ArrayList<IntDecision> md = new ArrayList<IntDecision>();
        DecisionPath dp = solver.getDecisionPath();
        int last = dp.size() - 1;
        System.out.printf("Conflict: ", new Object[0]);
        while (last > 0) {
            Decision decision = dp.getDecision(last--);
            IntDecision id = (IntDecision)decision.duplicate();
            if (decision.triesLeft() != id.triesLeft() - 1) {
                id.flip();
            }
            this.neighbor[--k] = id;
            if (lastExplanation.getDecisions().get(wi)) {
                md.add(id);
                this.incWeight(md, md.size() - 1, w);
                this.L.put(k, this.getWeight(md, md.size() - 1));
                System.out.printf("%s, ", this.neighbor[k]);
            }
            --wi;
        }
        System.out.printf("\n", new Object[0]);
        assert (md.size() == size);
        return md;
    }

    @Override
    public boolean init() {
        return this.move.init();
    }

    @Override
    public <V extends Variable> AbstractStrategy<V> getStrategy() {
        return this.move.getStrategy();
    }

    @Override
    public <V extends Variable> void setStrategy(AbstractStrategy<V> aStrategy) {
        this.move.setStrategy(aStrategy);
    }

    @Override
    public List<Move> getChildMoves() {
        return this.move.getChildMoves();
    }

    @Override
    public void setChildMoves(List<Move> someMoves) {
        this.move.setChildMoves(someMoves);
    }

    @Override
    public void setTopDecisionPosition(int position) {
        this.move.setTopDecisionPosition(position);
    }
}

