/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.loop.move;

import java.util.Collections;
import java.util.List;
import org.chocosolver.solver.Solution;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.search.limits.ICounter;
import org.chocosolver.solver.search.loop.lns.neighbors.INeighbor;
import org.chocosolver.solver.search.loop.move.Move;
import org.chocosolver.solver.search.strategy.decision.RootDecision;
import org.chocosolver.solver.search.strategy.strategy.AbstractStrategy;
import org.chocosolver.solver.variables.Variable;

public class MoveLNS
implements Move {
    protected Move move;
    protected INeighbor neighbor;
    protected long solutions;
    protected boolean freshRestart;
    protected ICounter counter;
    protected long frequency;

    public MoveLNS(Move move, INeighbor neighbor, ICounter restartCounter) {
        this.move = move;
        this.neighbor = neighbor;
        this.counter = restartCounter;
        this.frequency = this.counter.getLimitValue();
        this.solutions = 0L;
        this.freshRestart = false;
    }

    @Override
    public boolean init() {
        this.neighbor.init();
        return this.move.init();
    }

    @Override
    public boolean extend(Solver solver) {
        boolean extend;
        if (this.solutions > 0L) {
            if (this.freshRestart) {
                assert (solver.getDecisionPath().size() == 1);
                assert (solver.getDecisionPath().getDecision(0) == RootDecision.ROOT);
                this.neighbor.fixSomeVariables(solver.getDecisionPath());
                solver.getEnvironment().worldPush();
                this.freshRestart = false;
                extend = true;
            } else if (this.counter.isMet()) {
                this.doRestart(solver);
                extend = true;
            } else {
                extend = this.move.extend(solver);
            }
        } else {
            extend = this.move.extend(solver);
        }
        return extend;
    }

    @Override
    public boolean repair(Solver solver) {
        boolean repair;
        if (this.solutions > 0L || solver.getSolutionCount() > 0L) {
            if (this.solutions < solver.getSolutionCount()) {
                assert (this.solutions == solver.getSolutionCount() - 1L);
                ++this.solutions;
                this.neighbor.recordSolution();
                this.doRestart(solver);
                repair = true;
            } else if (this.freshRestart) {
                repair = false;
            } else {
                repair = this.move.repair(solver);
                if (!repair) {
                    if (!this.neighbor.isSearchComplete()) {
                        this.doRestart(solver);
                        repair = true;
                    }
                } else if (this.counter.isMet()) {
                    this.doRestart(solver);
                    repair = true;
                }
            }
        } else {
            repair = this.move.repair(solver);
        }
        return repair;
    }

    public void loadFromSolution(Solution solution, Solver solver) {
        this.neighbor.loadFromSolution(solution);
        if (this.solutions == 0L) {
            ++this.solutions;
            this.freshRestart = true;
        } else {
            this.doRestart(solver);
        }
    }

    @Override
    public void setTopDecisionPosition(int position) {
        this.move.setTopDecisionPosition(position);
    }

    @Override
    public <V extends Variable> AbstractStrategy<V> getStrategy() {
        return this.move.getStrategy();
    }

    @Override
    public <V extends Variable> void setStrategy(AbstractStrategy<V> aStrategy) {
        this.move.setStrategy(aStrategy);
    }

    protected void doRestart(Solver solver) {
        if (!this.freshRestart) {
            this.neighbor.restrictLess();
        }
        this.freshRestart = true;
        this.counter.overrideLimit(this.counter.currentValue() + this.frequency);
        solver.restart();
    }

    @Override
    public List<Move> getChildMoves() {
        return Collections.singletonList(this.move);
    }

    @Override
    public void setChildMoves(List<Move> someMoves) {
        if (someMoves.size() != 1) {
            throw new UnsupportedOperationException("Only one child move can be attached to it.");
        }
        this.move = someMoves.get(0);
    }
}

