/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.loop.move;

import java.util.Collections;
import java.util.List;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.search.loop.move.Move;
import org.chocosolver.solver.search.strategy.decision.Decision;
import org.chocosolver.solver.search.strategy.strategy.AbstractStrategy;
import org.chocosolver.solver.variables.Variable;

public class MoveBinaryDFS
implements Move {
    protected AbstractStrategy strategy;
    protected int topDecisionPosition;

    public MoveBinaryDFS() {
        this(null);
    }

    public MoveBinaryDFS(AbstractStrategy strategy) {
        this.strategy = strategy;
    }

    @Override
    public boolean init() {
        return this.strategy.init();
    }

    @Override
    public boolean extend(Solver solver) {
        boolean extended = false;
        Decision current = this.strategy.getDecision();
        if (current != null) {
            solver.getDecisionPath().pushDecision(current);
            solver.getEnvironment().worldPush();
            extended = true;
        }
        return extended;
    }

    @Override
    public boolean repair(Solver solver) {
        solver.getMeasures().incBackTrackCount();
        solver.getMeasures().decDepth();
        solver.getEnvironment().worldPop();
        return this.rewind(solver);
    }

    @Override
    public void setTopDecisionPosition(int position) {
        this.topDecisionPosition = position;
    }

    @Override
    public <V extends Variable> AbstractStrategy<V> getStrategy() {
        return this.strategy;
    }

    @Override
    public <V extends Variable> void setStrategy(AbstractStrategy<V> aStrategy) {
        this.strategy = aStrategy;
    }

    protected boolean rewind(Solver solver) {
        boolean repaired = false;
        Decision head = solver.getDecisionPath().getLastDecision();
        while (!repaired && head.getPosition() != this.topDecisionPosition) {
            solver.setJumpTo(solver.getJumpTo() - 1);
            if (solver.getJumpTo() <= 0 && head.hasNext()) {
                solver.getEnvironment().worldPush();
                repaired = true;
            } else {
                this.prevDecision(solver);
            }
            head = solver.getDecisionPath().getLastDecision();
        }
        return repaired;
    }

    protected void prevDecision(Solver solver) {
        solver.getDecisionPath().synchronize();
        solver.getSearchMonitors().afterUpBranch();
        solver.getMeasures().incBackTrackCount();
        solver.getMeasures().decDepth();
        solver.getEnvironment().worldPop();
        solver.getSearchMonitors().beforeUpBranch();
    }

    @Override
    public List<Move> getChildMoves() {
        return Collections.emptyList();
    }

    @Override
    public void setChildMoves(List<Move> someMoves) {
        if (someMoves.size() > 0) {
            throw new UnsupportedOperationException("This is a terminal Move. No child move can be attached to it.");
        }
    }
}

