/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.loop.move;

import org.chocosolver.cutoffseq.GeometricalCutoffStrategy;
import org.chocosolver.cutoffseq.ICutoffStrategy;
import org.chocosolver.cutoffseq.LubyCutoffStrategy;
import org.chocosolver.memory.IEnvironment;
import org.chocosolver.solver.ISelf;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.search.limits.ICounter;
import org.chocosolver.solver.search.limits.SolutionCounter;
import org.chocosolver.solver.search.loop.lns.neighbors.INeighbor;
import org.chocosolver.solver.search.loop.move.MoveBinaryDDS;
import org.chocosolver.solver.search.loop.move.MoveBinaryDFS;
import org.chocosolver.solver.search.loop.move.MoveBinaryHBFS;
import org.chocosolver.solver.search.loop.move.MoveBinaryLDS;
import org.chocosolver.solver.search.loop.move.MoveLNS;
import org.chocosolver.solver.search.loop.move.MoveRestart;
import org.chocosolver.solver.search.restart.MonotonicRestartStrategy;
import org.chocosolver.util.criteria.LongCriterion;

public interface IMoveFactory
extends ISelf<Solver> {
    default public void setDFS() {
        ((Solver)this._me()).setMove(new MoveBinaryDFS(((Solver)this._me()).getSearch()));
    }

    default public void setLDS(int discrepancy) {
        IEnvironment env = ((Solver)this._me()).getEnvironment();
        ((Solver)this._me()).setMove(new MoveBinaryLDS(((Solver)this._me()).getSearch(), discrepancy, env));
    }

    default public void setDDS(int discrepancy) {
        IEnvironment env = ((Solver)this._me()).getEnvironment();
        ((Solver)this._me()).setMove(new MoveBinaryDDS(((Solver)this._me()).getSearch(), discrepancy, env));
    }

    default public void setHBFS(double a, double b, long N) {
        ((Solver)this._me()).setMove(new MoveBinaryHBFS(((Solver)this._me()).getModel(), ((Solver)this._me()).getSearch(), a, b, N));
    }

    default public void setRestarts(LongCriterion restartCriterion, ICutoffStrategy restartStrategy, int restartsLimit) {
        ((Solver)this._me()).setMove(new MoveRestart(((Solver)this._me()).getMove(), restartStrategy, restartCriterion, restartsLimit));
    }

    default public void setLubyRestart(int scaleFactor, ICounter restartStrategyLimit, int restartLimit) {
        ((Solver)this._me()).setRestarts(restartStrategyLimit, new LubyCutoffStrategy(scaleFactor), restartLimit);
    }

    default public void setGeometricalRestart(int scaleFactor, double geometricalFactor, ICounter restartStrategyLimit, int restartLimit) {
        ((Solver)this._me()).setRestarts(restartStrategyLimit, new GeometricalCutoffStrategy(scaleFactor, geometricalFactor), restartLimit);
    }

    default public void setRestartOnSolutions() {
        ((Solver)this._me()).setMove(new MoveRestart(((Solver)this._me()).getMove(), new MonotonicRestartStrategy(1), new SolutionCounter(((Solver)this._me()).getModel(), 1L), Integer.MAX_VALUE));
    }

    default public void setLNS(INeighbor neighbor, ICounter restartCounter) {
        ((Solver)this._me()).setMove(new MoveLNS(((Solver)this._me()).getMove(), neighbor, restartCounter));
    }

    default public void setLNS(INeighbor neighbor) {
        this.setLNS(neighbor, ICounter.Impl.None);
    }
}

