/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.loop.monitors;

import java.util.ArrayDeque;
import java.util.Arrays;
import org.chocosolver.sat.PropNogoods;
import org.chocosolver.sat.SatSolver;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.search.loop.monitors.IMonitorRestart;
import org.chocosolver.solver.search.strategy.assignments.DecisionOperatorFactory;
import org.chocosolver.solver.search.strategy.decision.Decision;
import org.chocosolver.solver.search.strategy.decision.IntDecision;
import org.chocosolver.solver.variables.IntVar;

public class NogoodFromRestarts
implements IMonitorRestart {
    private ArrayDeque<Decision> decisions;
    private final PropNogoods png;

    public NogoodFromRestarts(Model model) {
        this.png = model.getNogoodStore().getPropNogoods();
        this.decisions = new ArrayDeque(16);
    }

    @Override
    public void beforeRestart() {
        this.extractNogoodFromPath();
    }

    private void extractNogoodFromPath() {
        int d = (int)this.png.getModel().getSolver().getNodeCount();
        this.png.getModel().getSolver().getDecisionPath().transferInto(this.decisions, false);
        int[] lits = new int[d];
        int i = 0;
        while (!this.decisions.isEmpty()) {
            Decision decision = this.decisions.pollFirst();
            if (decision instanceof IntDecision) {
                IntDecision id = (IntDecision)decision;
                if (id.getDecOp() == DecisionOperatorFactory.makeIntEq()) {
                    if (id.hasNext() || id.getArity() == 1) {
                        lits[i++] = SatSolver.negated(this.png.Literal((IntVar)id.getDecisionVariable(), id.getDecisionValue(), true));
                        continue;
                    }
                    if (i == 0) {
                        this.png.addLearnt(SatSolver.negated(this.png.Literal((IntVar)id.getDecisionVariable(), id.getDecisionValue(), true)));
                        continue;
                    }
                    lits[i] = SatSolver.negated(this.png.Literal((IntVar)id.getDecisionVariable(), id.getDecisionValue(), true));
                    this.png.addLearnt(Arrays.copyOf(lits, i + 1));
                    continue;
                }
                if (id.getDecOp() == DecisionOperatorFactory.makeIntNeq()) {
                    if (id.hasNext()) {
                        lits[i++] = this.png.Literal((IntVar)id.getDecisionVariable(), id.getDecisionValue(), true);
                        continue;
                    }
                    if (i == 0) {
                        this.png.addLearnt(this.png.Literal((IntVar)id.getDecisionVariable(), id.getDecisionValue(), true));
                        continue;
                    }
                    lits[i] = this.png.Literal((IntVar)id.getDecisionVariable(), id.getDecisionValue(), true);
                    this.png.addLearnt(Arrays.copyOf(lits, i + 1));
                    continue;
                }
                throw new UnsupportedOperationException("NogoodStoreFromRestarts cannot deal with such operator: " + ((IntDecision)decision).getDecOp());
            }
            throw new UnsupportedOperationException("NogoodStoreFromRestarts can only deal with IntDecision.");
        }
    }
}

