/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.loop.monitors;

import org.chocosolver.solver.Model;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.search.loop.monitors.IMonitorContradiction;
import org.chocosolver.util.objects.IntMap;

public class FailPerPropagator
implements IMonitorContradiction {
    protected IntMap p2w = new IntMap(10, 0);

    public FailPerPropagator(Constraint[] constraints, Model model) {
        this.init(constraints);
        model.getSolver().plugMonitor(this);
    }

    private void init(Constraint[] constraints) {
        for (Constraint cstr : constraints) {
            for (Propagator propagator : cstr.getPropagators()) {
                this.p2w.put(propagator.getId(), 0);
            }
        }
    }

    @Override
    public void onContradiction(ContradictionException cex) {
        if (cex.c != null && cex.c instanceof Propagator) {
            this.p2w.putOrAdjust(((Propagator)cex.c).getId(), 1, 1);
        }
    }

    public int getFails(Propagator p) {
        int f = this.p2w.get(p.getId());
        return f < 0 ? 0 : f;
    }
}

