/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.loop.monitors;

import com.github.cpprofiler.Connector;
import gnu.trove.stack.TIntStack;
import gnu.trove.stack.array.TIntArrayStack;
import java.io.Closeable;
import java.io.IOException;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.search.loop.monitors.IMonitorContradiction;
import org.chocosolver.solver.search.loop.monitors.IMonitorDownBranch;
import org.chocosolver.solver.search.loop.monitors.IMonitorRestart;
import org.chocosolver.solver.search.loop.monitors.IMonitorSolution;
import org.chocosolver.solver.search.loop.monitors.IMonitorUpBranch;
import org.chocosolver.solver.search.strategy.decision.Decision;
import org.chocosolver.solver.search.strategy.decision.DecisionPath;
import org.chocosolver.solver.trace.IMessage;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.iterators.DisposableRangeIterator;

public class CPProfiler
implements IMonitorDownBranch,
IMonitorUpBranch,
IMonitorSolution,
IMonitorContradiction,
IMonitorRestart,
Closeable {
    public static boolean DEBUG = false;
    private Model mModel;
    private TIntStack pid_stack = new TIntArrayStack();
    private TIntStack alt_stack = new TIntArrayStack();
    private TIntStack last_stack = new TIntArrayStack();
    private int nc = 0;
    private int rid;
    private int last;
    private Connector connector = new Connector();
    private boolean connected = false;
    private boolean sendDomain;
    private IMessage solutionMessage = new IMessage(){

        @Override
        public String print() {
            StringBuilder s = new StringBuilder(32);
            for (Variable v : CPProfiler.this.mModel.getVars()) {
                s.append(v).append(' ');
            }
            return s.toString();
        }
    };
    private IMessage domainMessage = new IMessage(){

        @Override
        public String print() {
            StringBuilder s = new StringBuilder(32);
            s.append("{\"domains\":{");
            for (Variable v : CPProfiler.this.mModel.getVars()) {
                if ((v.getTypeAndKind() & 8) > 0) {
                    s.append("\"").append(v.getName()).append("\":\"");
                    IntVar iv = (IntVar)v;
                    DisposableRangeIterator rit = iv.getRangeIterator(true);
                    while (rit.hasNext()) {
                        int from = rit.min();
                        int to = rit.max();
                        s.append(from);
                        if (from < to) {
                            s.append("..").append(to);
                        }
                        s.append(',');
                        rit.next();
                    }
                    rit.dispose();
                }
                s.setLength(s.length() - 1);
                s.append("\",");
            }
            s.setLength(s.length() - 1);
            s.append("}}");
            return s.toString();
        }
    };

    public CPProfiler(Model aModel, boolean sendDomain) {
        this.mModel = aModel;
        this.sendDomain = sendDomain;
        if (DEBUG) {
            System.out.printf("connector.restart(%d);\n", this.mModel.getSolver().getRestartCount());
        }
        try {
            this.connector.connect(6565);
            this.connector.restart(aModel.getName(), 0);
            this.mModel.getSolver().plugMonitor(this);
            this.connected = true;
            this.alt_stack.push(-1);
            this.pid_stack.push(-1);
            this.last_stack.push(-1);
        }
        catch (IOException e) {
            System.err.println("Unable to connect to CPProfiler, make sure it is started. No information will be sent.");
        }
    }

    @Override
    public void close() throws IOException {
        if (this.connected) {
            this.connector.disconnect();
            this.mModel.getSolver().unplugMonitor(this);
        }
        this.connected = false;
    }

    @Override
    public void beforeDownBranch(boolean left) {
        if (this.connected) {
            if (left) {
                DecisionPath dp = this.mModel.getSolver().getDecisionPath();
                int last = dp.size() - 1;
                if (last > 0) {
                    String pdec;
                    int first;
                    for (int i = first = dp.indexPreviousLevelLastLevel(); i < last; ++i) {
                        pdec = CPProfiler.pretty(dp.getDecision(i - 1));
                        assert (dp.getDecision(i).getArity() == 1);
                        this.send(this.nc, this.pid_stack.peek(), this.alt_stack.pop(), 1, this.rid, Connector.NodeStatus.BRANCH, pdec, this.sendDomain ? this.domainMessage.print() : "");
                        this.pid_stack.push(this.nc);
                        ++this.nc;
                        this.alt_stack.push(0);
                        this.last_stack.push(this.nc - 1);
                    }
                    pdec = CPProfiler.pretty(dp.getDecision(last - 1));
                    Decision dec = dp.getLastDecision();
                    int ari = dec.getArity();
                    this.send(this.nc, this.pid_stack.peek(), this.alt_stack.pop(), ari, this.rid, Connector.NodeStatus.BRANCH, pdec, this.sendDomain ? this.domainMessage.print() : "");
                    for (int i = 0; i < ari; ++i) {
                        this.pid_stack.push(this.nc);
                    }
                    ++this.nc;
                    this.alt_stack.push(0);
                    this.last_stack.push(this.nc - 1);
                }
            } else {
                ++this.nc;
                this.alt_stack.push(1);
                this.last_stack.push(this.last);
            }
        }
    }

    @Override
    public void beforeUpBranch() {
        this.last = this.last_stack.pop();
        while (this.pid_stack.peek() != this.last) {
            this.pid_stack.pop();
        }
        this.pid_stack.pop();
    }

    @Override
    public void onSolution() {
        String dec = CPProfiler.pretty(this.mModel.getSolver().getDecisionPath().getLastDecision());
        this.send(this.nc, this.pid_stack.peek(), this.alt_stack.pop(), 0, this.rid, Connector.NodeStatus.SOLVED, dec, this.solutionMessage.print());
    }

    @Override
    public void onContradiction(ContradictionException cex) {
        String dec = CPProfiler.pretty(this.mModel.getSolver().getDecisionPath().getLastDecision());
        this.send(this.nc, this.pid_stack.peek(), this.alt_stack.pop(), 0, this.rid, Connector.NodeStatus.FAILED, dec, cex.toString());
    }

    @Override
    public void afterRestart() {
        if (DEBUG) {
            System.out.printf("connector.restart(%d);\n", this.mModel.getSolver().getRestartCount());
        }
        if (this.connected) {
            try {
                this.connector.restart(++this.rid);
            }
            catch (IOException e) {
                System.err.println("Lost connection with CPProfiler. No more information will be sent.");
                this.connected = false;
            }
            this.pid_stack.clear();
            this.alt_stack.clear();
            this.alt_stack.push(-1);
            this.pid_stack.push(-1);
            this.last_stack.push(-1);
            this.nc = 0;
        }
    }

    private void send(int nc, int pid, int alt, int kid, int rid, Connector.NodeStatus status, String label, String info) {
        if (DEBUG) {
            System.out.printf("connector.sendNode(%d, %d, %d, 0, %s, %d, \"%s\", \"%s\");\n", nc, pid, alt, status.toString(), rid, label, info);
        }
        try {
            this.connector.createNode(nc, pid, alt, kid, status).setRestartId(rid).setLabel(label).setInfo(info).send();
        }
        catch (IOException e) {
            System.err.println("Lost connection with CPProfiler. No more information will be sent.");
            this.connected = false;
        }
    }

    private static String pretty(Decision dec) {
        if (dec == null) {
            return "ROOT";
        }
        int a = dec.getArity();
        int b = dec.triesLeft();
        dec.rewind();
        while (dec.triesLeft() > b + 1) {
            --a;
            dec.buildNext();
        }
        String pretty = dec.toString();
        while (a > b) {
            ++b;
            dec.buildNext();
        }
        return pretty;
    }
}

