/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.loop.lns.neighbors;

import java.util.BitSet;
import java.util.Random;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.Solution;
import org.chocosolver.solver.search.loop.lns.neighbors.INeighbor;
import org.chocosolver.solver.search.strategy.assignments.DecisionOperatorFactory;
import org.chocosolver.solver.search.strategy.decision.DecisionPath;
import org.chocosolver.solver.search.strategy.decision.IntDecision;
import org.chocosolver.solver.variables.IntVar;

public class RandomNeighborhood
implements INeighbor {
    protected final int n;
    protected final IntVar[] vars;
    protected final int[] bestSolution;
    private Random rd;
    private double nbFixedVariables = 0.0;
    protected int nbCall;
    protected int limit;
    protected final int level;
    protected BitSet fragment;
    protected Model mModel;

    public RandomNeighborhood(IntVar[] vars, int level, long seed) {
        this.mModel = vars[0].getModel();
        this.n = vars.length;
        this.vars = (IntVar[])vars.clone();
        this.level = level;
        this.rd = new Random(seed);
        this.bestSolution = new int[this.n];
        this.fragment = new BitSet(this.n);
    }

    @Override
    public void init() {
    }

    @Override
    public boolean isSearchComplete() {
        return false;
    }

    @Override
    public void recordSolution() {
        for (int i = 0; i < this.vars.length; ++i) {
            this.bestSolution[i] = this.vars[i].getValue();
        }
        this.nbFixedVariables = 2.0 * (double)this.n / 3.0 + 1.0;
        this.nbCall = 0;
        this.limit = 200;
    }

    @Override
    public void loadFromSolution(Solution solution) {
        for (int i = 0; i < this.vars.length; ++i) {
            this.bestSolution[i] = solution.getIntVal(this.vars[i]);
        }
        this.nbFixedVariables = 2.0 * (double)this.n / 3.0 + 1.0;
        this.nbCall = 0;
        this.limit = 200;
    }

    @Override
    public void fixSomeVariables(DecisionPath decisionPath) {
        ++this.nbCall;
        this.restrictLess();
        this.fragment.set(0, this.n);
        int i = 0;
        while ((double)i < this.nbFixedVariables - 1.0 && this.fragment.cardinality() > 0) {
            int id = this.selectVariable();
            if (this.vars[id].contains(this.bestSolution[id])) {
                this.impose(id, decisionPath);
            }
            this.fragment.clear(id);
            ++i;
        }
    }

    protected void impose(int id, DecisionPath decisionPath) {
        IntDecision decision = decisionPath.makeIntDecision(this.vars[id], DecisionOperatorFactory.makeIntEq(), this.bestSolution[id]);
        decision.setRefutable(false);
        decisionPath.pushDecision(decision);
    }

    protected int selectVariable() {
        int id = this.fragment.nextSetBit(0);
        for (int cc = this.rd.nextInt(this.fragment.cardinality()); id >= 0 && cc > 0; --cc) {
            id = this.fragment.nextSetBit(id + 1);
        }
        return id;
    }

    @Override
    public void restrictLess() {
        if (this.nbCall > this.limit) {
            this.limit = this.nbCall + this.level;
            this.nbFixedVariables = this.rd.nextDouble() * (double)this.n;
        }
    }
}

