/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.loop.lns.neighbors;

import java.util.BitSet;
import java.util.Random;
import java.util.SortedMap;
import java.util.TreeMap;
import org.chocosolver.solver.Cause;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.Solution;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.search.loop.lns.neighbors.INeighbor;
import org.chocosolver.solver.search.strategy.assignments.DecisionOperatorFactory;
import org.chocosolver.solver.search.strategy.decision.DecisionPath;
import org.chocosolver.solver.search.strategy.decision.IntDecision;
import org.chocosolver.solver.variables.IntVar;

public class PropagationGuidedNeighborhood
implements INeighbor {
    protected final int n;
    protected final IntVar[] vars;
    protected final int[] bestSolution;
    protected int[] dsize;
    protected Random rd;
    protected int fgmtSize = 100;
    protected int listSize;
    protected double epsilon = 1.0;
    protected double logSum = 0.0;
    protected SortedMap<Integer, Integer> all;
    protected SortedMap<Integer, Integer> candidate;
    protected BitSet fragment;
    protected Model mModel;

    public PropagationGuidedNeighborhood(IntVar[] vars, int fgmtSize, int listSize, long seed) {
        this.mModel = vars[0].getModel();
        this.n = vars.length;
        this.vars = (IntVar[])vars.clone();
        this.rd = new Random(seed);
        this.bestSolution = new int[this.n];
        this.fgmtSize = fgmtSize;
        this.listSize = listSize;
        this.all = new TreeMap<Integer, Integer>();
        this.candidate = new TreeMap<Integer, Integer>();
        this.fragment = new BitSet(this.n);
    }

    @Override
    public boolean isSearchComplete() {
        return false;
    }

    @Override
    public void recordSolution() {
        for (int i = 0; i < this.vars.length; ++i) {
            this.bestSolution[i] = this.vars[i].getValue();
        }
    }

    @Override
    public void loadFromSolution(Solution solution) {
        for (int i = 0; i < this.vars.length; ++i) {
            this.bestSolution[i] = solution.getIntVal(this.vars[i]);
        }
    }

    @Override
    public void fixSomeVariables(DecisionPath decisionPath) {
        this.logSum = 0.0;
        for (int i = 0; i < this.n; ++i) {
            int ds = this.vars[i].getDomainSize();
            this.logSum += Math.log(ds);
        }
        this.fgmtSize = (int)(30.0 * (1.0 + this.epsilon));
        this.fragment.set(0, this.n);
        this.mModel.getEnvironment().worldPush();
        try {
            this.update(decisionPath);
        }
        catch (ContradictionException cex) {
            this.mModel.getSolver().getEngine().flush();
        }
        this.mModel.getEnvironment().worldPop();
        this.epsilon = 0.95 * this.epsilon + 0.05 * (this.logSum / (double)this.fgmtSize);
    }

    protected void update(DecisionPath decisionPath) throws ContradictionException {
        while (this.logSum > (double)this.fgmtSize && this.fragment.cardinality() > 0) {
            this.all.clear();
            int id = this.selectVariable();
            if (this.vars[id].contains(this.bestSolution[id])) {
                this.impose(id, decisionPath);
                this.mModel.getSolver().propagate();
                this.fragment.clear(id);
                this.logSum = 0.0;
                for (int i = 0; i < this.n; ++i) {
                    int ds = this.vars[i].getDomainSize();
                    this.logSum += Math.log(ds);
                    if (!this.fragment.get(i)) continue;
                    if (ds == 1) {
                        this.fragment.clear(i);
                        continue;
                    }
                    if (this.dsize[i] - ds <= 0) continue;
                    this.all.put(i, Integer.MAX_VALUE - (this.dsize[i] - ds));
                }
                this.candidate.clear();
                int k = 0;
                while (!this.all.isEmpty() && this.candidate.size() < this.listSize) {
                    int first = this.all.firstKey();
                    this.all.remove(first);
                    if (!this.fragment.get(first)) continue;
                    this.candidate.put(first, k++);
                }
                continue;
            }
            this.fragment.clear(id);
            this.logSum -= Math.log(this.vars[id].getDomainSize());
        }
    }

    protected void impose(int id, DecisionPath decisionPath) throws ContradictionException {
        IntDecision decision = decisionPath.makeIntDecision(this.vars[id], DecisionOperatorFactory.makeIntEq(), this.bestSolution[id]);
        decision.setRefutable(false);
        decisionPath.pushDecision(decision);
        this.vars[id].instantiateTo(this.bestSolution[id], Cause.Null);
    }

    protected int selectVariable() {
        int id;
        if (this.candidate.isEmpty()) {
            id = this.fragment.nextSetBit(0);
            for (int cc = this.rd.nextInt(this.fragment.cardinality()); id >= 0 && cc > 0; --cc) {
                id = this.fragment.nextSetBit(id + 1);
            }
        } else {
            id = this.candidate.firstKey();
            this.candidate.remove(id);
        }
        return id;
    }

    @Override
    public void restrictLess() {
        this.epsilon += 0.1 * (this.logSum / (double)this.fgmtSize);
    }

    @Override
    public void init() {
        this.dsize = new int[this.n];
        for (int i = 0; i < this.n; ++i) {
            this.dsize[i] = this.vars[i].getDomainSize();
        }
    }
}

