/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.loop.lns.neighbors;

import gnu.trove.list.array.TIntArrayList;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import org.chocosolver.cutoffseq.GeometricalCutoffStrategy;
import org.chocosolver.cutoffseq.ICutoffStrategy;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.ResolutionPolicy;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.explanations.ArrayEventStore;
import org.chocosolver.solver.explanations.Explanation;
import org.chocosolver.solver.explanations.ExplanationEngine;
import org.chocosolver.solver.explanations.NoExplanationEngine;
import org.chocosolver.solver.explanations.RuleStore;
import org.chocosolver.solver.objective.IObjectiveManager;
import org.chocosolver.solver.search.loop.lns.neighbors.ExplainingCut;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.events.IntEventType;

class ExplainingObjective
extends ExplainingCut {
    private IObjectiveManager<IntVar> om;
    private IntVar objective;
    private int LB;
    private int UB;
    private final TIntArrayList clusters = new TIntArrayList(16);
    private ICutoffStrategy geo4cluster;
    private int cluster;
    private final TIntArrayList tmpDeductions = new TIntArrayList();
    private final TIntSet tmpValueDeductions = new TIntHashSet(16);

    ExplainingObjective(Model aModel, int level, long seed) {
        super(aModel, level, seed);
        this.geo4cluster = new GeometricalCutoffStrategy(1, 1.2);
    }

    @Override
    public void recordSolution() {
        this.tmpDeductions.clear();
        this.tmpValueDeductions.clear();
        this.clusters.clear();
        this.mDecisionPath.clear();
        this.readRemovedValues();
        this.buildCluster();
        this.clonePath();
        this.related.clear();
        for (int i = 0; i < this.tmpDeductions.size(); ++i) {
            this.related.set(this.tmpDeductions.get(i));
        }
        this.unrelated.clear();
        this.unrelated.or(this.related);
        this.unrelated.flip(0, this.mModel.getSolver().getDecisionPath().size());
        this.unrelated.clear(0);
        this.forceCft = true;
    }

    @Override
    protected void _fixVar() {
        if (this.cluster < this.clusters.size()) {
            int k;
            if ((k = this.cluster++) < this.clusters.size()) {
                for (int i = this.clusters.get(k - 1); i < this.clusters.get(k); ++i) {
                    int idx = this.tmpDeductions.get(i);
                    this.notFrozen.clear(idx);
                }
            }
        } else {
            super._fixVar();
        }
    }

    @Override
    public void init() {
        Solver r = this.mModel.getSolver();
        this.om = r.getObjectiveManager();
        this.objective = this.om.getObjective();
        this.LB = this.objective.getLB();
        this.UB = this.objective.getUB();
        if (this.mExplanationEngine == null) {
            if (r.getExplainer() == NoExplanationEngine.SINGLETON) {
                r.setExplainer(new ExplanationEngine(this.mModel, false, false));
            }
            this.mExplanationEngine = r.getExplainer();
        }
    }

    @Override
    protected void explain() {
        this.forceCft = false;
        this.nbFixedVariables = this.related.cardinality();
        this.nbCall = 0;
        this.increaseLimit();
        this.cluster = 1;
        this.notFrozen.clear();
        this.notFrozen.or(this.related);
    }

    private void readRemovedValues() {
        this.clusters.add(0);
        if (this.objective.hasEnumeratedDomain()) {
            this.readRemovedValuesE();
        } else {
            this.readRemovedValuesB();
        }
    }

    private void readRemovedValuesE() {
        boolean ismax;
        boolean bl = ismax = this.om.getPolicy() == ResolutionPolicy.MAXIMIZE;
        if (ismax) {
            int near = this.objective.getValue() + 1;
            for (int far = this.UB; far >= near; --far) {
                this.explainValueE(far);
            }
        } else {
            int near = this.objective.getValue() - 1;
            for (int far = this.LB; far <= near; ++far) {
                this.explainValueE(far);
            }
        }
    }

    private void explainValueE(int value) {
        Explanation explanation = this.mExplanationEngine.makeExplanation(false);
        RuleStore rs = this.mExplanationEngine.getRuleStore();
        rs.init(explanation);
        rs.addRemovalRule(this.objective, value);
        ArrayEventStore es = this.mExplanationEngine.getEventStore();
        for (int i = es.getSize() - 1; i > -1; --i) {
            if (!rs.match(i, es)) continue;
            rs.update(i, es, explanation);
        }
        int b = explanation.getDecisions().nextSetBit(0);
        while (b >= 0) {
            this.tmpValueDeductions.add(b);
            b = explanation.getDecisions().nextSetBit(b + 1);
        }
        assert (this.tmpValueDeductions.size() > 0) : "E(" + value + ") is EMPTY";
        this.tmpValueDeductions.removeAll(this.tmpDeductions);
        if (this.tmpDeductions.addAll(this.tmpValueDeductions)) {
            this.clusters.add(this.tmpDeductions.size());
        }
        explanation.recycle();
    }

    private void readRemovedValuesB() {
        int i;
        this.clusters.add(0);
        boolean ismax = this.om.getPolicy() == ResolutionPolicy.MAXIMIZE;
        Explanation explanation = this.mExplanationEngine.makeExplanation(false);
        RuleStore rs = this.mExplanationEngine.getRuleStore();
        ArrayEventStore es = this.mExplanationEngine.getEventStore();
        rs.init(explanation);
        if (ismax) {
            int far = this.UB;
            int near = this.objective.getValue() + 1;
            rs.addUpperBoundRule(this.objective);
            for (i = 0; i < es.getSize(); ++i) {
                if (!rs.match(i, es)) continue;
                int val = es.getFirstValue(i);
                int old = es.getSecondValue(i);
                if (es.getEventType(i) == IntEventType.INSTANTIATE) {
                    old = es.getThirdValue(i);
                }
                if (far >= near && far > val && far <= old) {
                    this.explainValueB(far, es, i);
                    far = val;
                    rs.init(explanation);
                }
                if (far >= near) continue;
                explanation.recycle();
                return;
            }
        } else {
            int far = this.LB;
            int near = this.objective.getValue() - 1;
            rs.addLowerBoundRule(this.objective);
            while (i < es.getSize()) {
                if (rs.match(i, es)) {
                    int val = es.getFirstValue(i);
                    int old = es.getSecondValue(i);
                    if (far <= near && far < val && far >= old) {
                        this.explainValueB(far, es, i);
                        far = val;
                        rs.init(explanation);
                    }
                    if (far > near) {
                        explanation.recycle();
                        return;
                    }
                }
                ++i;
            }
        }
        explanation.recycle();
    }

    private void explainValueB(int value, ArrayEventStore es, int i) {
        Explanation explanation = this.mExplanationEngine.makeExplanation(false);
        RuleStore rs = this.mExplanationEngine.getRuleStore();
        rs.init(explanation);
        rs.addRemovalRule(this.objective, value);
        while (i > -1) {
            if (rs.match(i, es)) {
                rs.update(i, es, explanation);
            }
            --i;
        }
        int b = explanation.getDecisions().nextSetBit(0);
        while (b >= 0) {
            this.tmpValueDeductions.add(b);
            b = explanation.getDecisions().nextSetBit(b + 1);
        }
        this.tmpValueDeductions.removeAll(this.tmpDeductions);
        if (this.tmpDeductions.addAll(this.tmpValueDeductions)) {
            this.clusters.add(this.tmpDeductions.size());
        }
        explanation.recycle();
    }

    private void buildCluster() {
        if (this.clusters.size() > 1) {
            int one = this.clusters.get(1);
            this.clusters.clear();
            this.clusters.add(0);
            this.clusters.add(one);
            this.geo4cluster = new GeometricalCutoffStrategy(1, 1.2);
            int j = 0;
            for (int i = one + 1; i < this.tmpDeductions.size(); i += this.geo4cluster.getNextCutoff()) {
                this.clusters.add(i);
                ++j;
            }
            if (this.clusters.get(this.clusters.size() - 1) != this.tmpDeductions.size() - 1) {
                this.clusters.add(this.tmpDeductions.size() - 1);
            }
        }
    }
}

