/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.loop.lns.neighbors;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Random;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.Solution;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.explanations.Explanation;
import org.chocosolver.solver.explanations.ExplanationEngine;
import org.chocosolver.solver.explanations.IExplanationEngine;
import org.chocosolver.solver.explanations.NoExplanationEngine;
import org.chocosolver.solver.search.loop.lns.neighbors.INeighbor;
import org.chocosolver.solver.search.strategy.decision.Decision;
import org.chocosolver.solver.search.strategy.decision.DecisionPath;
import org.chocosolver.solver.search.strategy.decision.IntDecision;
import org.chocosolver.util.tools.StatisticUtils;

public class ExplainingCut
implements INeighbor {
    protected IExplanationEngine mExplanationEngine;
    protected final Random random;
    protected List<IntDecision> mDecisionPath;
    protected BitSet related;
    protected BitSet unrelated;
    protected BitSet notFrozen;
    protected boolean forceCft;
    private boolean isTerminated;
    protected double nbFixedVariables = 0.0;
    protected int nbCall;
    private int limit;
    private final int level;
    protected Model mModel;

    public ExplainingCut(Model aModel, int level, long seed) {
        this.mModel = aModel;
        this.level = level;
        this.random = new Random(seed);
        this.mDecisionPath = new ArrayList<IntDecision>();
        this.related = new BitSet(16);
        this.notFrozen = new BitSet(16);
        this.unrelated = new BitSet(16);
    }

    @Override
    public void init() {
    }

    @Override
    public void recordSolution() {
        if (this.mExplanationEngine == null) {
            if (this.mModel.getSolver().getExplainer() == NoExplanationEngine.SINGLETON) {
                this.mModel.getSolver().setExplainer(new ExplanationEngine(this.mModel, false, false));
            }
            this.mExplanationEngine = this.mModel.getSolver().getExplainer();
        }
        this.clonePath();
        this.forceCft = true;
    }

    @Override
    public void loadFromSolution(Solution solution) {
        throw new UnsupportedOperationException("ExplanintCut does not support loading a solution");
    }

    @Override
    public void fixSomeVariables(DecisionPath decisionPath) {
        assert (this.mModel.getSolver().getDecisionPath().size() == 1) : "unexpected size " + this.mModel.getSolver().getDecisionPath().size();
        if (this.forceCft) {
            this.explain();
        }
        this._fixVar();
        assert (this.mModel.getSolver().getDecisionPath().size() == 1) : "unexpected size " + this.mModel.getSolver().getDecisionPath().size();
        this.notFrozen.or(this.unrelated);
        int id = this.notFrozen.nextSetBit(0);
        while (id >= 0) {
            decisionPath.pushDecision(this.mDecisionPath.get(id).duplicate());
            id = this.notFrozen.nextSetBit(id + 1);
        }
    }

    protected void _fixVar() {
        ++this.nbCall;
        this.restrictLess();
        this.notFrozen.clear();
        this.notFrozen.or(this.related);
        while (!this.notFrozen.isEmpty() && (double)(this.notFrozen.cardinality() + 1) > this.nbFixedVariables) {
            int idx = this.selectVariable();
            this.notFrozen.clear(idx);
        }
    }

    @Override
    public void restrictLess() {
        if (this.nbCall > this.limit) {
            this.nbFixedVariables = this.random.nextDouble() * (double)this.related.cardinality();
            this.increaseLimit();
        }
    }

    @Override
    public boolean isSearchComplete() {
        return this.isTerminated;
    }

    protected void increaseLimit() {
        long ank = (long)(1.2 * (double)StatisticUtils.binomialCoefficients(this.related.cardinality(), (int)this.nbFixedVariables - 1));
        int step = (int)Math.min(ank, (long)this.level);
        this.limit = this.nbCall + step;
    }

    private int selectVariable() {
        int id = this.notFrozen.nextSetBit(0);
        for (int cc = this.random.nextInt(this.notFrozen.cardinality()); id >= 0 && cc > 0; --cc) {
            id = this.notFrozen.nextSetBit(id + 1);
        }
        return id;
    }

    protected void clonePath() {
        this.mDecisionPath.clear();
        this.mDecisionPath.add(null);
        DecisionPath dp = this.mModel.getSolver().getDecisionPath();
        int last = dp.size();
        while (last > 1) {
            this.addToPath(dp.getDecision(--last));
        }
    }

    private void addToPath(Decision dec) {
        IntDecision id = (IntDecision)dec;
        boolean tofree = false;
        if (id.getArity() > 1 && !id.hasNext()) {
            id = id.flip();
            tofree = true;
        }
        this.mDecisionPath.add(id.duplicate());
        if (tofree) {
            id.free();
        }
    }

    protected void explain() {
        int i;
        this.forceCft = false;
        this.mModel.getEnvironment().worldPush();
        DecisionPath dp = this.mModel.getSolver().getDecisionPath();
        try {
            assert (this.mModel.getSolver().getDecisionPath().size() == 1);
            this.mModel.getSolver().getObjectiveManager().postDynamicCut();
            for (i = this.mDecisionPath.size() - 1; i > 0; --i) {
                dp.pushDecision(this.mDecisionPath.get(i).duplicate());
                dp.apply();
                this.mModel.getSolver().propagate();
            }
            assert (false) : "SHOULD FAIL!";
        }
        catch (ContradictionException cex) {
            if (cex.v != null || cex.c != null) {
                Explanation explanation = this.mExplanationEngine.explain(cex);
                if (explanation.getDecisions().isEmpty()) {
                    this.isTerminated = true;
                    this.mModel.getEnvironment().worldPop();
                    this.mModel.getSolver().getEngine().flush();
                    return;
                }
                this.related.clear();
                this.related.or(explanation.getDecisions());
                explanation.recycle();
                this.unrelated.clear();
                this.unrelated.or(this.related);
                this.unrelated.flip(0, i);
                this.unrelated.clear(0);
                for (i = 0; i > 1; --i) {
                    this.mDecisionPath.remove(1);
                }
            }
            throw new UnsupportedOperationException(this.getClass().getName() + ".onContradiction incoherent state");
        }
        this.mModel.getEnvironment().worldPop();
        dp.synchronize();
        this.mModel.getSolver().getEngine().flush();
        assert (this.mModel.getSolver().getDecisionPath().size() == 1);
        this.nbFixedVariables = this.related.cardinality() - 1;
        this.nbCall = 0;
        this.increaseLimit();
    }
}

