/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.loop.lns;

import org.chocosolver.solver.Model;
import org.chocosolver.solver.search.loop.lns.neighbors.ExplainingCut;
import org.chocosolver.solver.search.loop.lns.neighbors.INeighbor;
import org.chocosolver.solver.search.loop.lns.neighbors.PropagationGuidedNeighborhood;
import org.chocosolver.solver.search.loop.lns.neighbors.RandomNeighborhood;
import org.chocosolver.solver.search.loop.lns.neighbors.ReversePropagationGuidedNeighborhood;
import org.chocosolver.solver.search.loop.lns.neighbors.SequenceNeighborhood;
import org.chocosolver.solver.variables.IntVar;

public class INeighborFactory {
    public static INeighbor blackBox(IntVar ... vars) {
        return INeighborFactory.sequencer(INeighborFactory.propagationGuided(vars), INeighborFactory.reversedPropagationGuided(vars), INeighborFactory.random(vars));
    }

    public static INeighbor random(IntVar ... vars) {
        return new RandomNeighborhood(vars, 3, 0L);
    }

    public static INeighbor propagationGuided(IntVar ... vars) {
        return new PropagationGuidedNeighborhood(vars, 30, 10, 0L);
    }

    public static INeighbor reversedPropagationGuided(IntVar ... vars) {
        return new ReversePropagationGuidedNeighborhood(vars, 0, 30, 10L);
    }

    public static INeighbor explanationBased(IntVar ... vars) {
        Model model = vars[0].getModel();
        ExplainingCut neighbor2 = new ExplainingCut(model, 5, 0L);
        RandomNeighborhood neighbor3 = new RandomNeighborhood(vars, 5, 0L);
        return INeighborFactory.sequencer(neighbor2, neighbor3);
    }

    public static INeighbor sequencer(INeighbor ... neighbors) {
        return new SequenceNeighborhood(neighbors);
    }
}

