/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.loop.learn;

import org.chocosolver.solver.Model;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.explanations.Explanation;
import org.chocosolver.solver.explanations.ExplanationEngine;
import org.chocosolver.solver.explanations.IExplanationEngine;
import org.chocosolver.solver.explanations.NoExplanationEngine;
import org.chocosolver.solver.search.loop.learn.Learn;
import org.chocosolver.solver.search.strategy.decision.Decision;
import org.chocosolver.solver.search.strategy.decision.DecisionPath;

public class LearnExplained
implements Learn {
    protected final Model mModel;
    protected final IExplanationEngine mExplainer;
    private final boolean saveCauses;
    private long nbsol = 0L;
    protected Explanation lastExplanation;

    public LearnExplained(Model mModel, boolean partialExplanationsOn, boolean recordCauses) {
        this.mModel = mModel;
        if (mModel.getSolver().getExplainer() == NoExplanationEngine.SINGLETON) {
            mModel.getSolver().setExplainer(new ExplanationEngine(mModel, partialExplanationsOn, recordCauses));
        }
        this.mExplainer = mModel.getSolver().getExplainer();
        this.saveCauses = recordCauses;
    }

    @Override
    public void record(Solver solver) {
        if (this.nbsol == solver.getSolutionCount()) {
            this.onFailure(solver);
        } else {
            ++this.nbsol;
            this.onSolution(solver);
        }
    }

    @Override
    public void forget(Solver solver) {
    }

    public void onSolution(Solver solver) {
        DecisionPath path = this.mModel.getSolver().getDecisionPath();
        int i = path.size() - 1;
        Decision dec = path.getDecision(i);
        while (i > 0 && !dec.hasNext()) {
            dec = path.getDecision(--i);
        }
        if (i > 0) {
            Explanation explanation = this.mExplainer.makeExplanation(this.saveCauses);
            Decision d = path.getDecision(--i);
            while (i > 0) {
                if (d.hasNext()) {
                    explanation.addDecision(d);
                }
                d = path.getDecision(--i);
            }
            this.mExplainer.storeDecisionExplanation(dec, explanation);
        }
        solver.setJumpTo(1);
    }

    public void onFailure(Solver solver) {
        ContradictionException cex = this.mModel.getSolver().getContradictionException();
        assert (cex.v != null || cex.c != null) : this.getClass().getName() + ".onContradiction incoherent state";
        this.lastExplanation = this.mExplainer.explain(cex);
    }

    public final Explanation getLastExplanation() {
        return this.lastExplanation;
    }
}

