/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.loop.learn;

import java.util.ArrayDeque;
import java.util.BitSet;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.explanations.ArrayEventStore;
import org.chocosolver.solver.explanations.Explanation;
import org.chocosolver.solver.explanations.IExplanationEngine;
import org.chocosolver.solver.explanations.RuleStore;
import org.chocosolver.solver.search.loop.learn.LearnCBJ;
import org.chocosolver.solver.search.loop.monitors.IMonitorInitialize;
import org.chocosolver.solver.search.strategy.decision.Decision;
import org.chocosolver.solver.search.strategy.decision.DecisionPath;
import org.chocosolver.solver.search.strategy.decision.RootDecision;
import org.chocosolver.solver.search.strategy.strategy.AbstractStrategy;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;

public class LearnDBT
extends LearnCBJ {
    private final DBTstrategy dbTstrategy;
    private final RuleStore mRuleStore;
    private final ArrayEventStore mEventStore;

    public LearnDBT(Model mModel, boolean nogoodFromConflict, boolean userFeedbackOn) {
        super(mModel, nogoodFromConflict, userFeedbackOn);
        this.dbTstrategy = new DBTstrategy(mModel, this.mExplainer);
        this.mRuleStore = this.mExplainer.getRuleStore();
        this.mEventStore = this.mExplainer.getEventStore();
    }

    @Override
    protected void identifyRefutedDecision(int nworld) {
        this.dbTstrategy.clear();
        if (nworld == 1 || this.mModel.getSolver().getContradictionException().c == this.mModel.getSolver().getObjectiveManager()) {
            super.identifyRefutedDecision(nworld);
            return;
        }
        DecisionPath path = this.mModel.getSolver().getDecisionPath();
        int last = path.size();
        Decision jmpBck = path.getDecision(last - nworld);
        last = path.size();
        Decision dec = path.getDecision(--last);
        int decIdx = this.lastExplanation.getEvtstrIdx();
        while (dec != RootDecision.ROOT && nworld > 1) {
            Decision<IntVar> dup;
            if (dec.hasNext()) {
                dup = dec.duplicate();
                dup.setPosition(dec.getPosition());
                dup.rewind();
                this.dbTstrategy.add(dup);
            } else {
                Explanation anExplanation = this.mExplainer.getDecisionRefutationExplanation(dec);
                if (anExplanation.getEvtstrIdx() > 0) {
                    this.keepUp(anExplanation, decIdx);
                }
                if (!anExplanation.getDecisions().get(jmpBck.getPosition())) {
                    dup = dec.duplicate();
                    dup.setPosition(dec.getPosition());
                    dup.rewind();
                    dup.buildNext();
                    this.dbTstrategy.add(dup);
                } else {
                    this.mExplainer.freeDecisionExplanation(dec);
                }
            }
            dec = path.getDecision(--last);
            --nworld;
        }
        if (dec != RootDecision.ROOT) {
            if (dec.getArity() > 1 && !dec.hasNext()) {
                throw new UnsupportedOperationException("LearnDBT.identifyRefutedDecision should get to a POSITIVE decision " + dec);
            }
            this.lastExplanation.remove(dec);
            this.mExplainer.storeDecisionExplanation(dec, this.lastExplanation);
        }
    }

    private void keepUp(Explanation anExplanation, int decIdx) {
        int i;
        this.mRuleStore.init(anExplanation);
        for (i = anExplanation.getEvtstrIdx() - 1; i >= decIdx; --i) {
            if (!this.mRuleStore.match(i, this.mEventStore)) continue;
            this.mRuleStore.update(i, this.mEventStore, anExplanation);
        }
        anExplanation.setEvtstrIdx(i + 1);
        if (i == 0) {
            anExplanation.getRules().clear();
        }
    }

    private static class DBTstrategy
    extends AbstractStrategy<IntVar>
    implements IMonitorInitialize {
        private final ArrayDeque<Decision<IntVar>> decision_path = new ArrayDeque();
        private final Model mModel;
        private final IExplanationEngine mExplainer;
        private AbstractStrategy mainStrategy;

        protected DBTstrategy(Model model, IExplanationEngine mExplainer) {
            super((Variable[])new IntVar[0]);
            this.mModel = model;
            this.mExplainer = mExplainer;
            model.getSolver().plugMonitor(this);
        }

        protected void clear() {
            this.decision_path.clear();
        }

        protected void add(Decision<IntVar> dec) {
            this.decision_path.addLast(dec);
        }

        @Override
        public boolean init() {
            return this.mainStrategy.init();
        }

        @Override
        public void afterInitialize() {
            this.mainStrategy = this.mModel.getSolver().getSearch();
            this.mModel.getSolver().setSearch(this);
        }

        @Override
        public Decision getDecision() {
            if (this.decision_path.size() > 0) {
                int wi = this.mModel.getSolver().getDecisionPath().size();
                Decision<IntVar> d = this.decision_path.pollLast();
                int old = d.getPosition();
                if (old != wi) {
                    if (d.triesLeft() == 1) {
                        this.mExplainer.moveDecisionRefutation(d, wi);
                    }
                    for (Decision<IntVar> n : this.decision_path) {
                        BitSet bt;
                        if (n.triesLeft() != 1 || !(bt = this.mExplainer.getDecisionRefutationExplanation(n).getDecisions()).get(old)) continue;
                        bt.clear(old);
                        bt.set(wi);
                    }
                }
                d.setPosition(wi);
                return d;
            }
            return this.mainStrategy.getDecision();
        }

        @Override
        public String toString() {
            StringBuilder str = new StringBuilder();
            if (this.decision_path.size() > 0) {
                str.append(this.decision_path.toString());
            }
            str.append(this.mainStrategy.toString());
            return str.toString();
        }
    }
}

