/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.loop.learn;

import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import org.chocosolver.sat.PropNogoods;
import org.chocosolver.sat.SatSolver;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.search.loop.learn.LearnExplained;
import org.chocosolver.solver.search.strategy.decision.Decision;
import org.chocosolver.solver.search.strategy.decision.DecisionPath;
import org.chocosolver.solver.variables.IntVar;

public class LearnCBJ
extends LearnExplained {
    private final boolean nogoodFromConflict;
    private PropNogoods ngstore;
    private TIntList ps;

    public LearnCBJ(Model mModel, boolean nogoodFromConflict, boolean userFeedbackOn) {
        super(mModel, !nogoodFromConflict, userFeedbackOn);
        this.nogoodFromConflict = nogoodFromConflict;
        if (this.nogoodFromConflict) {
            this.ngstore = mModel.getNogoodStore().getPropNogoods();
            this.ps = new TIntArrayList();
        }
    }

    protected void identifyRefutedDecision(int nworld) {
        DecisionPath path = this.mModel.getSolver().getDecisionPath();
        int last = path.size() - 1;
        Decision dec = path.getLastDecision();
        while (last > 0 && nworld > 1) {
            this.mExplainer.freeDecisionExplanation(dec);
            --nworld;
            dec = path.getDecision(--last);
        }
        if (last > 0) {
            if (dec.getArity() > 1 && !dec.hasNext()) {
                throw new UnsupportedOperationException("LearnCBJ.identifyRefutedDecision should get to a LEFT decision:" + dec);
            }
            this.lastExplanation.remove(dec);
            this.mExplainer.storeDecisionExplanation(dec, this.lastExplanation);
        }
    }

    @Override
    public void onFailure(Solver solver) {
        super.onFailure(solver);
        if (this.nogoodFromConflict) {
            this.postNogood();
        }
        int upto = this.compute(this.mModel.getSolver().getDecisionPath());
        assert (upto > 0 && upto <= solver.getDecisionPath().size());
        solver.setJumpTo(upto);
        this.identifyRefutedDecision(upto);
    }

    private void postNogood() {
        if (this.lastExplanation.isComplete()) {
            Model mModel = this.ngstore.getModel();
            DecisionPath dp = mModel.getSolver().getDecisionPath();
            int last = dp.size() - 1;
            this.ps.clear();
            while (last > 0) {
                Decision decision = dp.getDecision(last--);
                if (!this.lastExplanation.getDecisions().get(decision.getPosition())) continue;
                assert (decision.hasNext());
                this.ps.add(SatSolver.negated(this.ngstore.Literal((IntVar)decision.getDecisionVariable(), (Integer)decision.getDecisionValue(), true)));
            }
            this.ngstore.addLearnt(this.ps.toArray());
        }
    }

    private int compute(DecisionPath decisionPath) {
        assert (decisionPath.size() >= this.lastExplanation.getDecisions().length());
        if (this.lastExplanation.getDecisions().cardinality() > 0) {
            return decisionPath.size() - this.lastExplanation.getDecisions().previousSetBit(this.lastExplanation.getDecisions().length());
        }
        return decisionPath.size();
    }

    @Override
    public void forget(Solver solver) {
        this.mExplainer.getRuleStore();
    }
}

