/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.loop;

import java.util.Arrays;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.propagation.hardcoded.SevenQueuesPropagatorEngine;
import org.chocosolver.solver.search.strategy.Search;
import org.chocosolver.solver.search.strategy.decision.Decision;
import org.chocosolver.solver.search.strategy.strategy.AbstractStrategy;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.util.ESat;

class RecursiveSearchLoop {
    RecursiveSearchLoop() {
    }

    public static int dfs(Model model, AbstractStrategy strategy) {
        int c = 0;
        try {
            model.getSolver().getEngine().propagate();
        }
        catch (ContradictionException e) {
            return c;
        }
        Decision dec = strategy.getDecision();
        if (dec != null) {
            model.getEnvironment().worldPush();
            try {
                dec.buildNext();
                dec.apply();
                c += RecursiveSearchLoop.dfs(model, strategy);
            }
            catch (ContradictionException cex) {
                model.getSolver().getEngine().flush();
            }
            model.getEnvironment().worldPop();
            model.getEnvironment().worldPush();
            try {
                dec.buildNext();
                dec.apply();
                c += RecursiveSearchLoop.dfs(model, strategy);
            }
            catch (ContradictionException cex) {
                model.getSolver().getEngine().flush();
            }
            model.getEnvironment().worldPop();
        } else {
            assert (model.getSolver().isSatisfied() == ESat.TRUE);
            ++c;
            System.out.printf("Solution: %s\n", Arrays.toString(model.getVars()));
        }
        return c;
    }

    public static int lds(Model model, AbstractStrategy strategy, int dis) {
        int c = 0;
        try {
            model.getSolver().getEngine().propagate();
        }
        catch (ContradictionException e) {
            return c;
        }
        Decision dec = strategy.getDecision();
        if (dec != null) {
            model.getEnvironment().worldPush();
            try {
                dec.buildNext();
                dec.apply();
                c += RecursiveSearchLoop.lds(model, strategy, dis);
            }
            catch (ContradictionException cex) {
                model.getSolver().getEngine().flush();
            }
            model.getEnvironment().worldPop();
            if (dis > 0) {
                model.getEnvironment().worldPush();
                try {
                    dec.buildNext();
                    dec.apply();
                    c += RecursiveSearchLoop.lds(model, strategy, dis - 1);
                }
                catch (ContradictionException cex) {
                    model.getSolver().getEngine().flush();
                }
                model.getEnvironment().worldPop();
            }
        } else {
            assert (model.getSolver().isSatisfied() == ESat.TRUE);
            ++c;
            System.out.printf("Solution: %s\n", Arrays.toString(model.getVars()));
        }
        return c;
    }

    public static int dds(Model model, AbstractStrategy strategy, int dis, int dep) {
        int c = 0;
        try {
            model.getSolver().getEngine().propagate();
        }
        catch (ContradictionException e) {
            return c;
        }
        Decision dec = strategy.getDecision();
        if (dec != null) {
            if (dep >= dis) {
                model.getEnvironment().worldPush();
                try {
                    dec.buildNext();
                    dec.apply();
                    c += RecursiveSearchLoop.ilds(model, strategy, dis, dep - 1);
                }
                catch (ContradictionException cex) {
                    model.getSolver().getEngine().flush();
                }
                model.getEnvironment().worldPop();
            } else {
                dec.buildNext();
            }
            if (dis > 0) {
                model.getEnvironment().worldPush();
                try {
                    dec.buildNext();
                    dec.apply();
                    c += RecursiveSearchLoop.ilds(model, strategy, dis - 1, dep);
                }
                catch (ContradictionException cex) {
                    model.getSolver().getEngine().flush();
                }
                model.getEnvironment().worldPop();
            }
        } else if (dis == 0) {
            assert (model.getSolver().isSatisfied() == ESat.TRUE);
            ++c;
            System.out.printf("Solution: %s\n", Arrays.toString(model.getVars()));
        }
        return c;
    }

    public static int ilds(Model model, AbstractStrategy strategy, int dis, int dep) {
        int c = 0;
        try {
            model.getSolver().getEngine().propagate();
        }
        catch (ContradictionException e) {
            return c;
        }
        Decision dec = strategy.getDecision();
        if (dec != null) {
            if (dep >= dis) {
                model.getEnvironment().worldPush();
                try {
                    dec.buildNext();
                    dec.apply();
                    c += RecursiveSearchLoop.ilds(model, strategy, dis, dep - 1);
                }
                catch (ContradictionException cex) {
                    model.getSolver().getEngine().flush();
                }
                model.getEnvironment().worldPop();
            } else {
                dec.buildNext();
            }
            if (dis > 0) {
                model.getEnvironment().worldPush();
                try {
                    dec.buildNext();
                    dec.apply();
                    c += RecursiveSearchLoop.ilds(model, strategy, dis - 1, dep);
                }
                catch (ContradictionException cex) {
                    model.getSolver().getEngine().flush();
                }
                model.getEnvironment().worldPop();
            }
        } else if (dis == 0) {
            assert (model.getSolver().isSatisfied() == ESat.TRUE);
            ++c;
            System.out.printf("Solution: %s\n", Arrays.toString(model.getVars()));
        }
        return c;
    }

    public static void main(String[] args) {
        Model model = new Model();
        IntVar[] X = model.intVarArray("X", 3, 0, 2, false);
        Solver r = model.getSolver();
        r.setEngine(new SevenQueuesPropagatorEngine(model));
        r.getEngine().initialize();
        System.out.printf("%d solutions\n", RecursiveSearchLoop.lds(model, Search.inputOrderLBSearch(X), 3));
    }
}

