/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.chocosolver.solver.ISelf;
import org.chocosolver.solver.Solution;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.constraints.nary.lex.PropLexInt;
import org.chocosolver.solver.objective.ParetoOptimizer;
import org.chocosolver.solver.search.measure.IMeasures;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;
import org.chocosolver.util.criteria.Criterion;

public interface IResolutionHelper
extends ISelf<Solver> {
    default public Solution findSolution(Criterion ... stop) {
        ((Solver)this._me()).getModel().clearObjective();
        ((Solver)this._me()).addStopCriterion(stop);
        boolean found = ((Solver)this._me()).solve();
        ((Solver)this._me()).removeStopCriterion(stop);
        if (found) {
            return new Solution(((Solver)this._me()).getModel(), new Variable[0]).record();
        }
        return null;
    }

    default public List<Solution> findAllSolutions(Criterion ... stop) {
        ((Solver)this._me()).getModel().clearObjective();
        ((Solver)this._me()).addStopCriterion(stop);
        ArrayList<Solution> solutions = new ArrayList<Solution>();
        while (((Solver)this._me()).solve()) {
            solutions.add(new Solution(((Solver)this._me()).getModel(), new Variable[0]).record());
        }
        ((Solver)this._me()).removeStopCriterion(stop);
        return solutions;
    }

    default public Stream<Solution> streamSolutions(final Criterion ... stop) {
        ((Solver)this._me()).addStopCriterion(stop);
        Spliterator<Solution> it = new Spliterator<Solution>(){

            @Override
            public boolean tryAdvance(Consumer<? super Solution> action) {
                if (((Solver)IResolutionHelper.this._me()).solve()) {
                    action.accept(new Solution(((Solver)IResolutionHelper.this._me()).getModel(), new Variable[0]).record());
                    return true;
                }
                ((Solver)IResolutionHelper.this._me()).removeStopCriterion(stop);
                return false;
            }

            @Override
            public Spliterator<Solution> trySplit() {
                return null;
            }

            @Override
            public long estimateSize() {
                return Long.MAX_VALUE;
            }

            @Override
            public int characteristics() {
                return 4369;
            }
        };
        return StreamSupport.stream(it, false);
    }

    default public Solution findOptimalSolution(IntVar objective, boolean maximize, Criterion ... stop) {
        ((Solver)this._me()).getModel().setObjective(maximize, objective);
        ((Solver)this._me()).addStopCriterion(stop);
        Solution s = new Solution(((Solver)this._me()).getModel(), new Variable[0]);
        while (((Solver)this._me()).solve()) {
            s.record();
        }
        ((Solver)this._me()).removeStopCriterion(stop);
        return ((Solver)this._me()).isFeasible() == ESat.TRUE ? s : null;
    }

    default public List<Solution> findAllOptimalSolutions(IntVar objective, boolean maximize, Criterion ... stop) {
        ((Solver)this._me()).addStopCriterion(stop);
        ((Solver)this._me()).findOptimalSolution(objective, maximize, new Criterion[0]);
        if (!((Solver)this._me()).isStopCriterionMet() && ((Solver)this._me()).getSolutionCount() > 0L) {
            ((Solver)this._me()).removeStopCriterion(stop);
            int opt = ((Solver)this._me()).getObjectiveManager().getBestSolutionValue().intValue();
            ((Solver)this._me()).reset();
            ((Solver)this._me()).getModel().clearObjective();
            ((Solver)this._me()).getModel().arithm(objective, "=", opt).post();
            return this.findAllSolutions(stop);
        }
        ((Solver)this._me()).removeStopCriterion(stop);
        return Collections.emptyList();
    }

    default public Stream<Solution> streamOptimalSolutions(IntVar objective, boolean maximize, Criterion ... stop) {
        ((Solver)this._me()).addStopCriterion(stop);
        ((Solver)this._me()).findOptimalSolution(objective, maximize, new Criterion[0]);
        if (!((Solver)this._me()).isStopCriterionMet() && ((Solver)this._me()).getSolutionCount() > 0L) {
            ((Solver)this._me()).removeStopCriterion(stop);
            int opt = ((Solver)this._me()).getObjectiveManager().getBestSolutionValue().intValue();
            ((Solver)this._me()).reset();
            ((Solver)this._me()).getModel().clearObjective();
            ((Solver)this._me()).getModel().arithm(objective, "=", opt).post();
            return this.streamSolutions(stop);
        }
        ((Solver)this._me()).removeStopCriterion(stop);
        return Stream.empty();
    }

    default public List<Solution> findParetoFront(IntVar[] objectives, boolean maximize, Criterion ... stop) {
        ((Solver)this._me()).addStopCriterion(stop);
        ParetoOptimizer pareto = new ParetoOptimizer(maximize, objectives);
        while (((Solver)this._me()).solve()) {
            pareto.onSolution();
        }
        ((Solver)this._me()).removeStopCriterion(stop);
        return pareto.getParetoFront();
    }

    default public Solution findLexOptimalSolution(IntVar[] objectives, boolean maximize, Criterion ... stop) {
        if (objectives == null || objectives.length == 0) {
            return this.findSolution(stop);
        }
        ((Solver)this._me()).addStopCriterion(stop);
        Solution sol = null;
        Constraint clint = null;
        PropLexInt plint = null;
        IntVar[] mobj = new IntVar[objectives.length];
        for (int i = 0; i < objectives.length; ++i) {
            mobj[i] = maximize ? ((Solver)this._me()).getModel().intMinusView(objectives[i]) : objectives[i];
        }
        while (((Solver)this._me()).solve()) {
            if (sol == null) {
                sol = new Solution(((Solver)this._me()).getModel(), new Variable[0]);
            }
            sol.record();
            int[] bestFound = new int[objectives.length];
            for (int vIdx = 0; vIdx < objectives.length; ++vIdx) {
                bestFound[vIdx] = sol.getIntVal(objectives[vIdx]) * (maximize ? -1 : 1);
            }
            if (plint != null) {
                plint.updateIntVector(bestFound);
                continue;
            }
            plint = new PropLexInt(mobj, bestFound, true);
            clint = new Constraint("lex objectives", plint);
            clint.post();
        }
        if (clint != null) {
            ((Solver)this._me()).getModel().unpost(clint);
        }
        ((Solver)this._me()).removeStopCriterion(stop);
        return sol;
    }

    default public void eachSolutionWithMeasure(BiConsumer<Solution, IMeasures> cons, Criterion ... stop) {
        ((Solver)this._me()).addStopCriterion(stop);
        Solution s = new Solution(((Solver)this._me()).getModel(), new Variable[0]);
        while (((Solver)this._me()).solve()) {
            cons.accept(s.record(), ((Solver)this._me()).getMeasures());
        }
        ((Solver)this._me()).removeStopCriterion(stop);
    }
}

