/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.propagation.hardcoded;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.exception.SolverException;
import org.chocosolver.solver.propagation.IPropagationEngine;
import org.chocosolver.solver.propagation.PropagationTrigger;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IEventType;
import org.chocosolver.solver.variables.events.PropagatorEventType;
import org.chocosolver.util.iterators.EvtScheduler;
import org.chocosolver.util.objects.IntCircularQueue;
import org.chocosolver.util.objects.IntMap;

public class TwoBucketPropagationEngine
implements IPropagationEngine {
    private static final int WORD_MASK = -1;
    private final Model model;
    private int size;
    private Propagator[] propagators;
    private final boolean DEBUG;
    private final short[] match_f;
    private final short[] match_c;
    private short max_f;
    private short max_c;
    private IntMap p2i;
    private Propagator lastProp;
    private int notEmpty;
    private ArrayDeque<Propagator>[] pro_queue_f;
    private boolean[] schedule_f;
    private IntCircularQueue[] event_f;
    private int[][] eventmasks;
    private ArrayDeque<Propagator>[] pro_queue_c;
    private boolean[] schedule_c;
    private PropagatorEventType[] event_c;
    private boolean init;
    private final PropagationTrigger trigger;

    public TwoBucketPropagationEngine(Model model) {
        this.trigger = new PropagationTrigger(this, model);
        this.model = model;
        this.match_f = model.getSettings().getFineEventPriority();
        this.match_c = model.getSettings().getCoarseEventPriority();
        this.DEBUG = model.getSettings().debugPropagation();
    }

    @Override
    public void initialize() throws SolverException {
        if (!this.init) {
            int i;
            ArrayList _propagators = new ArrayList();
            Constraint[] constraints = this.model.getCstrs();
            for (int c = 0; c < constraints.length; ++c) {
                Propagator[] cprops = constraints[c].getPropagators();
                Collections.addAll(_propagators, cprops);
            }
            this.propagators = _propagators.toArray(new Propagator[_propagators.size()]);
            this.size = _propagators.size();
            this.p2i = new IntMap(this.propagators.length);
            for (int j = 0; j < this.propagators.length; ++j) {
                if (this.p2i.containsKey(this.propagators[j].getId())) {
                    throw new SolverException("The following propagator is declared more than once into the propagation engine (this happens when a constraint is posted twice or when a posted constraint is also reified.)\n" + this.propagators[j] + " of " + this.propagators[j].getConstraint());
                }
                this.p2i.put(this.propagators[j].getId(), j);
            }
            short _max_ = -1;
            for (i = 0; i < this.match_f.length; ++i) {
                if (_max_ >= this.match_f[i]) continue;
                _max_ = this.match_f[i];
            }
            this.max_f = _max_ = (short)((short)(_max_ + 1));
            _max_ = -1;
            for (i = 0; i < this.match_c.length; ++i) {
                if (_max_ >= this.match_c[i]) continue;
                _max_ = this.match_c[i];
            }
            this.max_c = _max_ = (short)((short)(_max_ + 1));
            this.pro_queue_f = new ArrayDeque[this.max_f];
            for (i = 0; i < this.max_f; ++i) {
                this.pro_queue_f[i] = new ArrayDeque(this.propagators.length / 2 + 1);
            }
            this.schedule_f = new boolean[this.size];
            this.pro_queue_c = new ArrayDeque[this.max_c];
            for (i = 0; i < this.max_c; ++i) {
                this.pro_queue_c[i] = new ArrayDeque(this.propagators.length / 2 + 1);
            }
            this.schedule_c = new boolean[this.size];
            this.notEmpty = 0;
            this.event_f = new IntCircularQueue[this.size];
            this.eventmasks = new int[this.size][];
            for (i = 0; i < this.size; ++i) {
                if (!this.propagators[i].reactToFineEvent()) continue;
                int nbv = this.propagators[i].getNbVars();
                this.event_f[i] = new IntCircularQueue(nbv);
                this.eventmasks[i] = new int[nbv];
            }
            this.event_c = new PropagatorEventType[this.size];
            Arrays.fill(this.event_c, PropagatorEventType.VOID);
            this.init = true;
        }
        this.trigger.addAll(Arrays.copyOfRange(this.propagators, 0, this.size));
    }

    @Override
    public boolean isInitialized() {
        return this.init;
    }

    @Override
    public void propagate() throws ContradictionException {
        if (this.trigger.needToRun()) {
            this.trigger.propagate();
        }
        int i = this.nextNotEmpty(0);
        while (i > -1) {
            if (i == 0) {
                while (!this.pro_queue_f[i].isEmpty()) {
                    this.propagateFine(this.pro_queue_f[i]);
                }
                this.notEmpty &= 0xFFFFFFFE;
            } else if (i < this.max_f) {
                this.propagateFine(this.pro_queue_f[i]);
                if (this.pro_queue_f[i].isEmpty()) {
                    this.notEmpty &= ~(1 << i);
                }
            } else {
                int j = i - this.max_f;
                this.propagateCoarse(this.pro_queue_c[j]);
                if (this.pro_queue_c[j].isEmpty()) {
                    this.notEmpty &= ~(1 << i);
                }
            }
            i = this.nextNotEmpty(0);
        }
    }

    private int nextNotEmpty(int fromIndex) {
        int word = this.notEmpty & -1 << fromIndex;
        if (word != 0) {
            return Integer.numberOfTrailingZeros(word);
        }
        return -1;
    }

    private void propagateFine(ArrayDeque<Propagator> pro_queue_f) throws ContradictionException {
        this.lastProp = pro_queue_f.pollFirst();
        int aid = this.p2i.get(this.lastProp.getId());
        this.schedule_f[aid] = false;
        if (this.lastProp.reactToFineEvent()) {
            IntCircularQueue evtset = this.event_f[aid];
            while (!evtset.isEmpty()) {
                int v = evtset.pollFirst();
                assert (this.lastProp.isActive()) : "propagator is not active:" + this.lastProp;
                if (this.DEBUG) {
                    IPropagationEngine.Trace.printPropagation(this.lastProp.getVar(v), this.lastProp);
                }
                int mask = this.eventmasks[aid][v];
                this.eventmasks[aid][v] = 0;
                this.lastProp.propagate(v, mask);
            }
        } else if (this.lastProp.isActive()) {
            if (this.DEBUG) {
                IPropagationEngine.Trace.printPropagation(null, this.lastProp);
            }
            this.lastProp.propagate(PropagatorEventType.FULL_PROPAGATION.getMask());
        }
    }

    private void propagateCoarse(ArrayDeque<Propagator> pro_queue_c) throws ContradictionException {
        this.lastProp = pro_queue_c.pollFirst();
        int aid = this.p2i.get(this.lastProp.getId());
        assert (this.schedule_c[aid]) : "try to propagate an unscheduled propagator";
        this.schedule_c[aid] = false;
        PropagatorEventType evt = this.event_c[aid];
        this.event_c[aid] = PropagatorEventType.VOID;
        assert (this.lastProp.isActive()) : "propagator is not active:" + this.lastProp;
        if (this.DEBUG) {
            IPropagationEngine.Trace.printPropagation(null, this.lastProp);
        }
        this.lastProp.propagate(evt.getMask());
    }

    @Override
    public void flush() {
        if (this.lastProp != null) {
            this.flushFine(this.lastProp);
            this.flushCoarse(this.lastProp);
        }
        int i = this.nextNotEmpty(0);
        while (i > -1) {
            if (i < this.max_f) {
                while (!this.pro_queue_f[i].isEmpty()) {
                    this.flushFine(this.pro_queue_f[i].pollLast());
                }
            } else {
                while (!this.pro_queue_c[i - this.max_f].isEmpty()) {
                    this.flushCoarse(this.pro_queue_c[i - this.max_f].pollLast());
                }
            }
            this.notEmpty &= ~(1 << i);
            i = this.nextNotEmpty(0);
        }
        this.lastProp = null;
    }

    private void flushFine(Propagator prop) {
        int aid = this.p2i.get(prop.getId());
        if (prop.reactToFineEvent()) {
            IntCircularQueue evtset = this.event_f[aid];
            while (!evtset.isEmpty()) {
                this.eventmasks[aid][evtset.pollLast()] = 0;
            }
            evtset.clear();
        }
        this.schedule_f[aid] = false;
    }

    private void flushCoarse(Propagator prop) {
        int aid = this.p2i.get(prop.getId());
        this.schedule_c[aid] = false;
        this.event_c[aid] = PropagatorEventType.VOID;
    }

    @Override
    public void onVariableUpdate(Variable variable, IEventType type, ICause cause) {
        if (this.DEBUG) {
            IPropagationEngine.Trace.printModification(variable, type, cause);
        }
        Propagator[] vpropagators = variable.getPropagators();
        int[] vindices = variable.getPIndices();
        int mask = type.getMask();
        EvtScheduler<IEventType> si = variable._schedIter();
        si.init(type);
        while (si.hasNext()) {
            int t = variable.getDindex(si.next());
            for (int p = variable.getDindex(si.next()); p < t; ++p) {
                Propagator prop = vpropagators[p];
                if (cause == prop || !prop.isActive()) continue;
                this.schedule(prop, vindices[p], mask);
            }
        }
    }

    private void schedule(Propagator prop, int pindice, int mask) {
        int aid = this.p2i.get(prop.getId());
        if (prop.reactToFineEvent()) {
            if (this.eventmasks[aid][pindice] == 0) {
                if (this.DEBUG) {
                    IPropagationEngine.Trace.printFineSchedule(prop);
                }
                this.event_f[aid].addLast(pindice);
            }
            int[] nArray = this.eventmasks[aid];
            int n = pindice;
            nArray[n] = nArray[n] | mask;
        }
        if (!this.schedule_f[aid]) {
            PropagatorPriority prio = prop.getPriority();
            short q = this.match_f[prio.priority - 1];
            this.pro_queue_f[q].addLast(prop);
            this.schedule_f[aid] = true;
            this.notEmpty |= 1 << q;
            if (this.DEBUG) {
                IPropagationEngine.Trace.printCoarseSchedule(prop);
            }
        }
    }

    @Override
    public void delayedPropagation(Propagator propagator, PropagatorEventType type) throws ContradictionException {
        int aid = this.p2i.get(propagator.getId());
        if (!this.schedule_c[aid]) {
            PropagatorPriority prio = propagator.getPriority();
            short q = this.match_c[prio.priority - 1];
            this.pro_queue_c[q].addLast(propagator);
            this.schedule_c[aid] = true;
            this.event_c[aid] = type;
            this.notEmpty |= 1 << q + this.max_f;
        }
    }

    @Override
    public void onPropagatorExecution(Propagator propagator) {
        this.flushFine(propagator);
        this.flushCoarse(propagator);
    }

    @Override
    public void desactivatePropagator(Propagator propagator) {
        this.flushFine(propagator);
        this.flushCoarse(propagator);
    }

    @Override
    public void clear() {
        this.propagators = null;
        this.p2i = null;
        this.trigger.clear();
        this.max_f = 0;
        this.max_c = 0;
        this.pro_queue_f = null;
        this.schedule_f = null;
        this.pro_queue_c = null;
        this.schedule_c = null;
        this.notEmpty = 0;
        this.event_f = null;
        this.eventmasks = null;
        this.event_c = null;
        this.init = false;
        this.lastProp = null;
    }

    @Override
    public void dynamicAddition(boolean permanent, Propagator ... ps) throws SolverException {
        boolean resize;
        int osize = this.size;
        int nbp = ps.length;
        this.size += nbp;
        boolean bl = resize = this.size > this.propagators.length;
        if (resize) {
            int nsize = this.size * 3 / 2 + 1;
            Propagator[] _propagators = this.propagators;
            this.propagators = new Propagator[nsize];
            System.arraycopy(_propagators, 0, this.propagators, 0, osize);
            boolean[] _schedule_f = this.schedule_f;
            this.schedule_f = new boolean[nsize];
            System.arraycopy(_schedule_f, 0, this.schedule_f, 0, osize);
            boolean[] _schedule_c = this.schedule_c;
            this.schedule_c = new boolean[nsize];
            System.arraycopy(_schedule_c, 0, this.schedule_c, 0, osize);
            PropagatorEventType[] _event_c = this.event_c;
            this.event_c = new PropagatorEventType[nsize];
            System.arraycopy(_event_c, 0, this.event_c, 0, osize);
            Arrays.fill(this.event_c, osize, nsize, PropagatorEventType.VOID);
            IntCircularQueue[] _event_f = this.event_f;
            this.event_f = new IntCircularQueue[nsize];
            System.arraycopy(_event_f, 0, this.event_f, 0, osize);
            int[][] _eventmasks = this.eventmasks;
            this.eventmasks = new int[nsize][];
            System.arraycopy(_eventmasks, 0, this.eventmasks, 0, osize);
        }
        System.arraycopy(ps, 0, this.propagators, osize, nbp);
        for (int i = osize; i < this.size; ++i) {
            if (this.p2i.containsKey(this.propagators[i].getId())) {
                throw new SolverException("The following propagator is declared more than once into the propagation engine (this happens when a constraint is posted twice or when a posted constraint is also reified.)\n" + this.propagators[i] + " of " + this.propagators[i].getConstraint());
            }
            this.p2i.put(this.propagators[i].getId(), i);
            this.trigger.dynAdd(this.propagators[i], permanent);
            if (!this.propagators[i].reactToFineEvent()) continue;
            this.eventmasks[i] = new int[this.propagators[i].getNbVars()];
            this.event_f[i] = new IntCircularQueue(this.propagators[i].getNbVars());
        }
    }

    @Override
    public void updateInvolvedVariables(Propagator p) {
        if (p.reactToFineEvent()) {
            int i = this.p2i.get(p.getId());
            assert (!this.schedule_f[i] && !this.schedule_c[i]) : "Try to update variable scope during propagation";
            int nbv = p.getNbVars();
            this.eventmasks[i] = new int[nbv];
            this.event_f[i] = new IntCircularQueue(nbv);
        }
        this.propagateOnBacktrack(p);
    }

    @Override
    public void propagateOnBacktrack(Propagator p) {
        this.trigger.propagateOnBacktrack(p);
    }

    @Override
    public void dynamicDeletion(Propagator ... ps) {
        for (Propagator toDelete : ps) {
            if (this.lastProp == toDelete) {
                this.lastProp = null;
            }
            --this.size;
            Propagator toMove = this.propagators[this.size];
            int idtd = this.p2i.get(toDelete.getId());
            int idtm = this.p2i.get(toMove.getId());
            this.p2i.clear(toDelete.getId());
            assert (idtd <= idtm) : "wrong id for prop to delete";
            if (idtd < this.size) {
                this.propagators[idtd] = toMove;
                this.p2i.put(toMove.getId(), idtd);
                this.schedule_f[idtd] = this.schedule_f[idtm];
                this.schedule_c[idtd] = this.schedule_c[idtm];
                this.event_f[idtd] = this.event_f[idtm];
                this.event_c[idtd] = this.event_c[idtm];
                this.eventmasks[idtd] = this.eventmasks[idtm];
            }
            this.trigger.remove(toDelete);
        }
    }
}

