/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.propagation.hardcoded;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.exception.SolverException;
import org.chocosolver.solver.propagation.IPropagationEngine;
import org.chocosolver.solver.propagation.PropagationTrigger;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IEventType;
import org.chocosolver.solver.variables.events.PropagatorEventType;
import org.chocosolver.util.iterators.EvtScheduler;
import org.chocosolver.util.objects.IntCircularQueue;
import org.chocosolver.util.objects.IntMap;
import org.chocosolver.util.objects.queues.CircularQueue;

public class SevenQueuesPropagatorEngine
implements IPropagationEngine {
    private static final int WORD_MASK = -1;
    private final boolean DEBUG;
    private final Model model;
    private int size;
    private Propagator[] propagators;
    private final CircularQueue<Propagator>[] pro_queue;
    private Propagator lastProp;
    private IntMap p2i;
    private int notEmpty;
    private short[] scheduled;
    private IntCircularQueue[] eventsets;
    private int delayedPropagationType;
    private boolean init;
    private int[][] eventmasks;
    private final PropagationTrigger trigger;

    public SevenQueuesPropagatorEngine(Model model) {
        this.trigger = new PropagationTrigger(this, model);
        this.model = model;
        this.pro_queue = new CircularQueue[8];
        this.DEBUG = model.getSettings().debugPropagation();
    }

    @Override
    public void initialize() throws SolverException {
        if (!this.init) {
            int i;
            ArrayList _propagators = new ArrayList();
            Constraint[] constraints = this.model.getCstrs();
            for (int c = 0; c < constraints.length; ++c) {
                Propagator[] cprops = constraints[c].getPropagators();
                Collections.addAll(_propagators, cprops);
            }
            this.propagators = _propagators.toArray(new Propagator[_propagators.size()]);
            this.size = _propagators.size();
            this.p2i = new IntMap(this.size);
            for (int j = 0; j < this.size; ++j) {
                if (this.p2i.containsKey(this.propagators[j].getId())) {
                    throw new SolverException("The following propagator is declared more than once into the propagation engine (this happens when a constraint is posted twice or when a posted constraint is also reified.)\n" + this.propagators[j] + " of " + this.propagators[j].getConstraint());
                }
                this.p2i.put(this.propagators[j].getId(), j);
            }
            for (i = 0; i < 8; ++i) {
                this.pro_queue[i] = new CircularQueue(16);
            }
            this.scheduled = new short[this.size];
            this.eventsets = new IntCircularQueue[this.size];
            this.eventmasks = new int[this.size][];
            for (i = 0; i < this.size; ++i) {
                int nbv = this.propagators[i].getNbVars();
                if (!this.propagators[i].reactToFineEvent()) continue;
                this.eventsets[i] = new IntCircularQueue(nbv);
                this.eventmasks[i] = new int[nbv];
            }
            this.notEmpty = 0;
            this.init = true;
        }
        this.trigger.addAll(Arrays.copyOfRange(this.propagators, 0, this.size));
    }

    @Override
    public boolean isInitialized() {
        return this.init;
    }

    @Override
    public void propagate() throws ContradictionException {
        if (this.trigger.needToRun()) {
            this.trigger.propagate();
        }
        int i = this.nextNotEmpty(0);
        while (i > -1) {
            while (!this.pro_queue[i].isEmpty()) {
                this.lastProp = this.pro_queue[i].pollFirst();
                int aid = this.p2i.get(this.lastProp.getId());
                this.scheduled[aid] = 0;
                this.delayedPropagationType = 0;
                if (this.lastProp.reactToFineEvent()) {
                    IntCircularQueue evtset = this.eventsets[aid];
                    while (evtset.size() > 0) {
                        int v = evtset.pollFirst();
                        assert (this.lastProp.isActive()) : "propagator is not active:" + this.lastProp;
                        if (this.DEBUG) {
                            IPropagationEngine.Trace.printPropagation(this.lastProp.getVar(v), this.lastProp);
                        }
                        int mask = this.eventmasks[aid][v];
                        this.eventmasks[aid][v] = 0;
                        this.lastProp.propagate(v, mask);
                    }
                    if (this.delayedPropagationType <= 0) continue;
                    if (this.DEBUG) {
                        IPropagationEngine.Trace.printPropagation(null, this.lastProp);
                    }
                    this.lastProp.propagate(this.delayedPropagationType);
                    continue;
                }
                if (!this.lastProp.isActive()) continue;
                if (this.DEBUG) {
                    IPropagationEngine.Trace.printPropagation(null, this.lastProp);
                }
                this.lastProp.propagate(PropagatorEventType.FULL_PROPAGATION.getMask());
            }
            this.notEmpty &= ~(1 << i);
            i = this.nextNotEmpty(0);
        }
    }

    private int nextNotEmpty(int fromIndex) {
        int word = this.notEmpty & -1 << fromIndex;
        if (word != 0) {
            return Integer.numberOfTrailingZeros(word);
        }
        return -1;
    }

    @Override
    public void flush() {
        if (this.lastProp != null) {
            this.flush(this.lastProp);
        }
        int i = this.nextNotEmpty(0);
        while (i > -1) {
            while (!this.pro_queue[i].isEmpty()) {
                this.flush(this.pro_queue[i].pollLast());
            }
            this.notEmpty &= ~(1 << i);
            i = this.nextNotEmpty(i + 1);
        }
        this.lastProp = null;
    }

    private void flush(Propagator prop) {
        int aid = this.p2i.get(prop.getId());
        assert (aid > -1) : "cannot flush unknown propagator";
        if (prop.reactToFineEvent()) {
            IntCircularQueue evtset = this.eventsets[aid];
            while (evtset.size() > 0) {
                int v = evtset.pollLast();
                this.eventmasks[aid][v] = 0;
            }
            evtset.clear();
        }
        this.scheduled[aid] = 0;
    }

    @Override
    public void onVariableUpdate(Variable variable, IEventType type, ICause cause) {
        if (this.DEBUG) {
            IPropagationEngine.Trace.printModification(variable, type, cause);
        }
        Propagator[] vpropagators = variable.getPropagators();
        int[] vindices = variable.getPIndices();
        int mask = type.getMask();
        EvtScheduler<IEventType> si = variable._schedIter();
        si.init(type);
        while (si.hasNext()) {
            int t = variable.getDindex(si.next());
            for (int p = variable.getDindex(si.next()); p < t; ++p) {
                Propagator prop = vpropagators[p];
                if (!prop.isActive() || cause == prop) continue;
                this.schedule(prop, vindices[p], mask);
            }
        }
    }

    private void schedule(Propagator prop, int pindice, int mask) {
        int aid = this.p2i.get(prop.getId());
        if (prop.reactToFineEvent()) {
            if (this.eventmasks[aid][pindice] == 0) {
                if (this.DEBUG) {
                    IPropagationEngine.Trace.printFineSchedule(prop);
                }
                this.eventsets[aid].addLast(pindice);
            }
            int[] nArray = this.eventmasks[aid];
            int n = pindice;
            nArray[n] = nArray[n] | mask;
        }
        if (this.scheduled[aid] == 0) {
            int prio = prop.getPriority().priority;
            this.pro_queue[prio].addLast(prop);
            this.scheduled[aid] = (short)(prio + 1);
            this.notEmpty |= 1 << prio;
            if (this.DEBUG) {
                IPropagationEngine.Trace.printCoarseSchedule(prop);
            }
        }
    }

    @Override
    public void delayedPropagation(Propagator propagator, PropagatorEventType type) throws ContradictionException {
        assert (propagator == this.lastProp);
        assert (this.delayedPropagationType == 0 || this.delayedPropagationType == type.getMask());
        this.delayedPropagationType = type.getMask();
    }

    @Override
    public void onPropagatorExecution(Propagator propagator) {
        this.desactivatePropagator(propagator);
    }

    @Override
    public void desactivatePropagator(Propagator propagator) {
        int pid;
        int aid;
        if (propagator.reactToFineEvent() && (aid = this.p2i.get(pid = propagator.getId())) > -1) {
            assert (aid > -1) : "try to desactivate an unknown constraint";
            IntCircularQueue evtset = this.eventsets[aid];
            while (evtset.size() > 0) {
                int v = evtset.pollFirst();
                this.eventmasks[aid][v] = 0;
            }
            evtset.clear();
        }
    }

    @Override
    public void clear() {
        this.propagators = null;
        this.trigger.clear();
        this.p2i = null;
        for (int i = 0; i < 8; ++i) {
            this.pro_queue[i] = null;
        }
        this.scheduled = null;
        this.eventsets = null;
        this.eventmasks = null;
        this.notEmpty = 0;
        this.init = false;
        this.lastProp = null;
    }

    @Override
    public void dynamicAddition(boolean permanent, Propagator ... ps) throws SolverException {
        boolean resize;
        int osize = this.size;
        int nbp = ps.length;
        this.size += nbp;
        boolean bl = resize = this.size > this.propagators.length;
        if (resize) {
            int nsize = this.size * 3 / 2 + 1;
            Propagator[] _propagators = this.propagators;
            this.propagators = new Propagator[nsize];
            System.arraycopy(_propagators, 0, this.propagators, 0, osize);
            short[] _scheduled = this.scheduled;
            this.scheduled = new short[nsize];
            System.arraycopy(_scheduled, 0, this.scheduled, 0, osize);
            IntCircularQueue[] _eventsets = this.eventsets;
            this.eventsets = new IntCircularQueue[nsize];
            System.arraycopy(_eventsets, 0, this.eventsets, 0, osize);
            int[][] _eventmasks = this.eventmasks;
            this.eventmasks = new int[nsize][];
            System.arraycopy(_eventmasks, 0, this.eventmasks, 0, osize);
        }
        System.arraycopy(ps, 0, this.propagators, osize, nbp);
        for (int i = osize; i < this.size; ++i) {
            if (this.p2i.containsKey(this.propagators[i].getId())) {
                throw new SolverException("The following propagator is declared more than once into the propagation engine (this happens when a constraint is posted twice or when a posted constraint is also reified.)\n" + this.propagators[i] + " of " + this.propagators[i].getConstraint());
            }
            this.p2i.put(this.propagators[i].getId(), i);
            this.trigger.dynAdd(this.propagators[i], permanent);
            if (!this.propagators[i].reactToFineEvent()) continue;
            int nbv = this.propagators[i].getNbVars();
            this.eventsets[i] = new IntCircularQueue(nbv);
            this.eventmasks[i] = new int[nbv];
        }
    }

    @Override
    public void updateInvolvedVariables(Propagator p) {
        if (p.reactToFineEvent()) {
            int i = this.p2i.get(p.getId());
            assert (this.scheduled[i] == 0) : "Try to update variable scope during propagation";
            int nbv = p.getNbVars();
            this.eventsets[i] = new IntCircularQueue(nbv);
            this.eventmasks[i] = new int[nbv];
        }
        this.propagateOnBacktrack(p);
    }

    @Override
    public void propagateOnBacktrack(Propagator p) {
        this.trigger.propagateOnBacktrack(p);
    }

    @Override
    public void dynamicDeletion(Propagator ... ps) {
        for (Propagator toDelete : ps) {
            if (this.lastProp == toDelete) {
                this.lastProp = null;
            }
            --this.size;
            Propagator toMove = this.propagators[this.size];
            this.propagators[this.size] = null;
            int idtd = this.p2i.get(toDelete.getId());
            int idtm = this.p2i.get(toMove.getId());
            this.p2i.clear(toDelete.getId());
            assert (idtd <= idtm) : "wrong id for prop to delete";
            if (idtd < this.size) {
                this.propagators[idtd] = toMove;
                this.p2i.put(toMove.getId(), idtd);
                this.scheduled[idtd] = this.scheduled[idtm];
                assert (!toDelete.reactToFineEvent() || this.eventsets[idtd].isEmpty()) : "try to delete a propagator which has events to propagate (fine)";
                this.eventsets[idtd] = this.eventsets[idtm];
                this.eventmasks[idtd] = this.eventmasks[idtm];
            }
            this.trigger.remove(toDelete);
        }
    }
}

