/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.propagation;

import java.util.ArrayList;
import java.util.Arrays;
import org.chocosolver.memory.IEnvironment;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.propagation.IPropagationEngine;
import org.chocosolver.solver.variables.events.PropagatorEventType;
import org.chocosolver.util.objects.IntList;

public class PropagationTrigger {
    private final IPropagationEngine engine;
    private final IEnvironment environment;
    private final Model model;
    private final boolean DEBUG;
    private ArrayList<Propagator> sta_propagators = new ArrayList();
    private ArrayList<Propagator> perm_propagators = new ArrayList();
    private IntList perm_world = new IntList();
    private int size;

    public PropagationTrigger(IPropagationEngine engine, Model model) {
        this.engine = engine;
        this.environment = model.getEnvironment();
        this.model = model;
        this.size = 0;
        this.DEBUG = model.getSettings().debugPropagation();
    }

    public void addAll(Propagator ... propagators) {
        assert (this.perm_propagators.size() == this.perm_world.size());
        this.sta_propagators.addAll(Arrays.asList(propagators));
        this.size += propagators.length;
        if (this.model.getSettings().sortPropagatorActivationWRTPriority()) {
            this.sta_propagators.sort((p1, p2) -> {
                int p = p1.getPriority().priority - p2.getPriority().priority;
                if (p == 0) {
                    return p1.getNbVars() - p2.getNbVars();
                }
                return p;
            });
        }
    }

    public void propagateOnBacktrack(Propagator propagator) {
        assert (this.perm_propagators.size() == this.perm_world.size());
        int pos = this.find(propagator);
        if (pos == -1) {
            this.dynAdd(propagator, true);
        } else {
            this.perm_world.replaceQuick(pos, Integer.MAX_VALUE);
        }
    }

    private int find(Propagator p) {
        int i;
        for (i = 0; i < this.perm_propagators.size() && this.perm_propagators.get(i) != p; ++i) {
        }
        if (i == this.perm_propagators.size()) {
            return -1;
        }
        return i;
    }

    public void dynAdd(Propagator propagator, boolean permanent) {
        if (permanent) {
            assert (this.perm_propagators.size() == this.perm_world.size());
            this.perm_propagators.add(propagator);
            this.perm_world.add(Integer.MAX_VALUE);
            ++this.size;
        }
    }

    public void remove(Propagator propagator) {
        int idx = this.sta_propagators.indexOf(propagator);
        if (idx > -1) {
            this.sta_propagators.remove(idx);
        }
        if ((idx = this.perm_propagators.indexOf(propagator)) > -1) {
            this.perm_propagators.remove(idx);
            this.perm_world.removeAt(idx);
        }
    }

    public boolean needToRun() {
        return this.size > 0;
    }

    public void clear() {
        this.sta_propagators.clear();
        this.perm_propagators.clear();
        this.perm_world.clear();
        this.size = 0;
    }

    public void propagate() throws ContradictionException {
        if (this.sta_propagators.size() > 0) {
            for (int p = 0; p < this.sta_propagators.size(); ++p) {
                if (this.DEBUG) {
                    IPropagationEngine.Trace.printFirstPropagation(this.sta_propagators.get(p));
                }
                PropagationTrigger.execute(this.sta_propagators.get(p), this.engine);
            }
            this.size -= this.sta_propagators.size();
            this.sta_propagators.clear();
        }
        if (this.perm_propagators.size() > 0) {
            int cw = this.environment.getWorldIndex();
            for (int p = this.perm_propagators.size() - 1; p >= 0 && this.perm_world.getQuick(p) >= cw; --p) {
                PropagationTrigger.execute(this.perm_propagators.get(p), this.engine);
                this.perm_world.replaceQuick(p, cw);
            }
        }
    }

    public static void execute(Propagator toPropagate, IPropagationEngine engine) throws ContradictionException {
        if (toPropagate.isStateLess()) {
            toPropagate.setActive();
            toPropagate.propagate(PropagatorEventType.FULL_PROPAGATION.getMask());
            engine.onPropagatorExecution(toPropagate);
        } else if (toPropagate.isActive()) {
            toPropagate.propagate(PropagatorEventType.FULL_PROPAGATION.getMask());
            engine.onPropagatorExecution(toPropagate);
        }
    }
}

