/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.propagation;

import org.chocosolver.solver.ICause;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.exception.SolverException;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IEventType;
import org.chocosolver.solver.variables.events.PropagatorEventType;

public interface IPropagationEngine {
    default public void initialize() throws SolverException {
    }

    default public boolean isInitialized() {
        return false;
    }

    default public void propagate() throws ContradictionException {
    }

    default public void flush() {
    }

    @Deprecated
    default public void fails(ICause cause, Variable variable, String message) throws ContradictionException {
        throw new UnsupportedOperationException("replaced by {@link org.chocosolver.solver.Solver#throwsException(ICause, Variable, String)}");
    }

    @Deprecated
    default public ContradictionException getContradictionException() {
        throw new UnsupportedOperationException("replaced by {@link Solver#getContradictionException()}");
    }

    default public void clear() {
    }

    default public void onVariableUpdate(Variable variable, IEventType type, ICause cause) {
    }

    default public void delayedPropagation(Propagator propagator, PropagatorEventType type) throws ContradictionException {
    }

    default public void onPropagatorExecution(Propagator propagator) {
    }

    default public void desactivatePropagator(Propagator propagator) {
    }

    default public void dynamicAddition(boolean permanent, Propagator ... ps) throws SolverException {
    }

    default public void updateInvolvedVariables(Propagator p) {
    }

    default public void propagateOnBacktrack(Propagator p) {
    }

    default public void dynamicDeletion(Propagator ... ps) {
    }

    public static enum Trace {


        public static void printFirstPropagation(Propagator p) {
            p.getModel().getSolver().getOut().printf("[A] %s\n", p);
        }

        public static void printPropagation(Variable v, Propagator p) {
            if (v == null) {
                p.getModel().getSolver().getOut().printf("[P] %s\n", p);
            } else {
                p.getModel().getSolver().getOut().printf("[P] %s on %s\n", v, p);
            }
        }

        public static void printModification(Variable v, IEventType e, ICause c) {
            v.getModel().getSolver().getOut().printf("\t[M] %s %s b/c %s\n", v, e, c);
        }

        public static void printFineSchedule(Propagator p) {
            p.getModel().getSolver().getOut().printf("\t\t[FS] %s\n", p);
        }

        public static void printCoarseSchedule(Propagator p) {
            p.getModel().getSolver().getOut().printf("\t\t[CS] %s\n", p);
        }
    }
}

