/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.objective;

import java.util.LinkedList;
import java.util.List;
import org.chocosolver.sat.PropSat;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.Solution;
import org.chocosolver.solver.constraints.Operator;
import org.chocosolver.solver.search.loop.monitors.IMonitorSolution;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;

public class ParetoOptimizer
implements IMonitorSolution {
    private LinkedList<Solution> paretoFront;
    private Model model;
    private LinkedList<Solution> pool = new LinkedList();
    private boolean maximize;
    private IntVar[] objectives;
    private int n;
    private int[] vals;
    private int[] lits;
    private PropSat psat;

    public ParetoOptimizer(boolean maximize, IntVar[] objectives) {
        this.paretoFront = new LinkedList();
        this.objectives = (IntVar[])objectives.clone();
        this.maximize = maximize;
        this.n = objectives.length;
        this.model = objectives[0].getModel();
        this.psat = this.model.getMinisat().getPropSat();
        this.vals = new int[this.n];
        this.lits = new int[this.n];
    }

    @Override
    public void onSolution() {
        int i;
        for (i = 0; i < this.n; ++i) {
            this.vals[i] = this.objectives[i].getValue();
        }
        for (i = this.paretoFront.size() - 1; i >= 0; --i) {
            if (!this.isDominated(this.paretoFront.get(i), this.vals)) continue;
            this.pool.add(this.paretoFront.remove(i));
        }
        if (this.pool.isEmpty()) {
            this.paretoFront.add(new Solution(this.model, new Variable[0]).record());
        } else {
            Solution solution = this.pool.remove();
            solution.record();
            this.paretoFront.add(solution);
        }
        Operator symbol = Operator.GT;
        if (!this.maximize) {
            symbol = Operator.LT;
        }
        for (int i2 = 0; i2 < this.n; ++i2) {
            this.lits[i2] = this.psat.makeLiteral(this.model.arithm(this.objectives[i2], symbol.toString(), this.vals[i2]).reify(), true);
        }
        this.psat.addLearnt(this.lits);
    }

    public List<Solution> getParetoFront() {
        return this.paretoFront;
    }

    private boolean isDominated(Solution solution, int[] vals) {
        for (int i = 0; i < this.n; ++i) {
            int delta = solution.getIntVal(this.objectives[i]) - vals[i];
            if ((delta <= 0 || !this.maximize) && (delta >= 0 || this.maximize)) continue;
            return false;
        }
        return true;
    }
}

