/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.objective;

import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.ResolutionPolicy;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.objective.OptimizationPolicy;
import org.chocosolver.solver.search.strategy.assignments.DecisionOperator;
import org.chocosolver.solver.search.strategy.decision.Decision;
import org.chocosolver.solver.search.strategy.decision.IntDecision;
import org.chocosolver.solver.search.strategy.strategy.AbstractStrategy;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;

public class ObjectiveStrategy
extends AbstractStrategy<IntVar> {
    private int globalLB;
    private int globalUB;
    private int coefLB;
    private int coefUB;
    private IntVar obj;
    private long nbSols;
    private Model model;
    private boolean firstCall;
    private DecisionOperator<IntVar> decOperator;
    private OptimizationPolicy optPolicy;
    private DecisionOperator<IntVar> decUB = new DecisionOperator<IntVar>(){

        @Override
        public void apply(IntVar var, int value, ICause cause) throws ContradictionException {
            var.updateUpperBound(value, cause);
        }

        @Override
        public void unapply(IntVar var, int value, ICause cause) throws ContradictionException {
            ObjectiveStrategy.this.globalLB = value + 1;
            var.updateLowerBound(ObjectiveStrategy.this.globalLB, cause);
        }

        @Override
        public String toString() {
            return " objective split(" + ObjectiveStrategy.this.coefLB + "," + ObjectiveStrategy.this.coefUB + "), decreases the upper bound first";
        }

        @Override
        public DecisionOperator opposite() {
            return ObjectiveStrategy.this.incLB;
        }
    };
    private DecisionOperator<IntVar> incLB = new DecisionOperator<IntVar>(){

        @Override
        public void apply(IntVar var, int value, ICause cause) throws ContradictionException {
            var.updateLowerBound(value, cause);
        }

        @Override
        public void unapply(IntVar var, int value, ICause cause) throws ContradictionException {
            ObjectiveStrategy.this.globalUB = value - 1;
            var.updateUpperBound(ObjectiveStrategy.this.globalUB, cause);
        }

        @Override
        public String toString() {
            return " objective split(" + ObjectiveStrategy.this.coefLB + "," + ObjectiveStrategy.this.coefUB + "), increases the lower bound first";
        }

        @Override
        public DecisionOperator opposite() {
            return ObjectiveStrategy.this.decUB;
        }
    };

    public ObjectiveStrategy(IntVar objective, OptimizationPolicy policy) {
        this(objective, ObjectiveStrategy.getCoefs(policy), policy);
    }

    public ObjectiveStrategy(IntVar objective, int[] coefs, OptimizationPolicy policy) {
        super((Variable[])new IntVar[]{objective});
        this.obj = objective;
        this.model = this.obj.getModel();
        this.firstCall = true;
        this.coefLB = coefs[0];
        this.coefUB = coefs[1];
        this.optPolicy = policy;
        this.model.getSolver().setRestartOnSolutions();
        if (this.coefLB < 0 || this.coefUB < 0 || this.coefLB + this.coefUB == 0) {
            throw new UnsupportedOperationException("coefLB<0, coefUB<0 and coefLB+coefUB==0 are forbidden");
        }
        if (this.coefLB + this.coefUB != 1 && policy != OptimizationPolicy.DICHOTOMIC) {
            throw new UnsupportedOperationException("Invalid coefficients for BOTTOM_UP or TOP_DOWN optimization\nuse signature public ObjectiveStrategy(IntVar obj, OptimizationPolicy policy, Model model) instead");
        }
    }

    private static int[] getCoefs(OptimizationPolicy policy) {
        switch (policy) {
            case BOTTOM_UP: {
                return new int[]{1, 0};
            }
            case TOP_DOWN: {
                return new int[]{0, 1};
            }
            case DICHOTOMIC: {
                return new int[]{1, 1};
            }
        }
        throw new UnsupportedOperationException("unknown OptimizationPolicy " + (Object)((Object)policy));
    }

    private DecisionOperator<IntVar> getOperator(OptimizationPolicy optPolicy, ResolutionPolicy resoPolicy) {
        switch (optPolicy) {
            case BOTTOM_UP: {
                return this.decUB;
            }
            case TOP_DOWN: {
                return this.incLB;
            }
            case DICHOTOMIC: {
                switch (resoPolicy) {
                    case MINIMIZE: {
                        return this.decUB;
                    }
                    case MAXIMIZE: {
                        return this.incLB;
                    }
                }
                throw new UnsupportedOperationException("ObjectiveStrategy is not for " + (Object)((Object)resoPolicy) + " ResolutionPolicy");
            }
        }
        throw new UnsupportedOperationException("unknown OptimizationPolicy " + (Object)((Object)optPolicy));
    }

    @Override
    public boolean init() {
        this.decOperator = this.getOperator(this.optPolicy, this.model.getSolver().getObjectiveManager().getPolicy());
        return true;
    }

    @Override
    public Decision getDecision() {
        if (this.model.getSolver().getSolutionCount() == 0L || this.nbSols == this.model.getSolver().getSolutionCount() && this.optPolicy == OptimizationPolicy.DICHOTOMIC) {
            return null;
        }
        if (this.obj.isInstantiated()) {
            return null;
        }
        if (this.firstCall) {
            this.firstCall = false;
            this.globalLB = this.obj.getLB();
            this.globalUB = this.obj.getUB();
        }
        this.nbSols = this.model.getSolver().getSolutionCount();
        this.globalLB = Math.max(this.globalLB, this.obj.getLB());
        this.globalUB = Math.min(this.globalUB, this.obj.getUB());
        if (this.globalLB > this.globalUB) {
            return null;
        }
        if (this.model.getSettings().warnUser()) {
            this.model.getSolver().getErr().printf("- objective in [" + this.globalLB + ", " + this.globalUB + "]\n", new Object[0]);
        }
        int target = (this.globalLB * this.coefLB + this.globalUB * this.coefUB) / (this.coefLB + this.coefUB);
        IntDecision dec = this.model.getSolver().getDecisionPath().makeIntDecision(this.obj, this.decOperator, target);
        if (this.model.getSettings().warnUser()) {
            this.model.getSolver().getErr().printf("- trying " + this.obj + " " + (this.decOperator == this.decUB ? "<=" : ">=") + " " + target + "\n", new Object[0]);
        }
        return dec;
    }
}

