/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.objective;

import org.chocosolver.solver.ResolutionPolicy;
import org.chocosolver.solver.explanations.RuleStore;
import org.chocosolver.solver.objective.AbstractObjManager;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.events.IEventType;

abstract class AbstractIntObjManager
extends AbstractObjManager<IntVar> {
    private static final long serialVersionUID = 5539060355541720114L;

    public AbstractIntObjManager(AbstractIntObjManager objman) {
        super(objman);
    }

    public AbstractIntObjManager(IntVar objective, ResolutionPolicy policy, Number precision) {
        super(objective, policy, precision);
        this.bestProvedLB = objective.getLB() - 1;
        this.bestProvedUB = objective.getUB() + 1;
    }

    @Override
    public synchronized void updateBestLB(Number lb) {
        if (this.bestProvedLB.intValue() < lb.intValue()) {
            this.bestProvedLB = lb;
        }
    }

    @Override
    public synchronized void updateBestUB(Number ub) {
        if (this.bestProvedUB.intValue() > ub.intValue()) {
            this.bestProvedUB = ub;
        }
    }

    @Override
    public void updateBestSolution() {
        assert (((IntVar)this.objective).isInstantiated());
        this.updateBestSolution(((IntVar)this.objective).getValue());
    }

    @Override
    public void setStrictDynamicCut() {
        this.cutComputer = n -> n.intValue() + this.precision.intValue();
    }

    @Override
    public void resetBestBounds() {
        this.bestProvedLB = ((IntVar)this.objective).getLB() - 1;
        this.bestProvedUB = ((IntVar)this.objective).getUB() + 1;
    }

    @Override
    public boolean why(RuleStore ruleStore, IntVar var, IEventType evt, int value) {
        return this.isOptimization() && ruleStore.addBoundsRule((IntVar)this.objective);
    }

    public String toString() {
        return String.format("%s %s = %d", new Object[]{this.policy, this.objective == null ? "?" : ((IntVar)this.objective).getName(), this.getBestSolutionValue().intValue()});
    }
}

