/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.expression.discrete.relational;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.constraints.extension.Tuples;
import org.chocosolver.solver.constraints.extension.TuplesFactory;
import org.chocosolver.solver.expression.discrete.arithmetic.ArExpression;
import org.chocosolver.solver.expression.discrete.logical.BiLoExpression;
import org.chocosolver.solver.expression.discrete.logical.LoExpression;
import org.chocosolver.solver.expression.discrete.logical.NaLoExpression;
import org.chocosolver.solver.expression.discrete.logical.UnLoExpression;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IntVar;

public abstract class ReExpression
implements ArExpression {
    @Override
    public abstract Model getModel();

    public abstract BoolVar boolVar();

    @Override
    public IntVar intVar() {
        return this.boolVar();
    }

    @Override
    public abstract void extractVar(HashSet<IntVar> var1);

    public void post() {
        this.decompose().post();
    }

    public abstract Constraint decompose();

    public final Constraint extension() {
        LinkedHashSet<IntVar> avars = new LinkedHashSet<IntVar>();
        this.extractVar(avars);
        IntVar[] uvars = (IntVar[])avars.stream().sorted().toArray(IntVar[]::new);
        Map<IntVar, Integer> map = IntStream.range(0, uvars.length).boxed().collect(Collectors.toMap(i -> uvars[i], i -> i));
        Tuples tuples = TuplesFactory.generateTuples(values -> this.beval(values, map), true, uvars);
        return this.getModel().table(uvars, tuples);
    }

    public abstract boolean beval(int[] var1, Map<IntVar, Integer> var2);

    @Override
    public int ieval(int[] values, Map<IntVar, Integer> map) {
        return this.beval(values, map) ? 1 : 0;
    }

    public final ReExpression and(ReExpression ... y) {
        return new NaLoExpression(LoExpression.Operator.AND, this, y);
    }

    public final ReExpression or(ReExpression ... y) {
        return new NaLoExpression(LoExpression.Operator.OR, this, y);
    }

    public final ReExpression xor(ReExpression y) {
        return new BiLoExpression(LoExpression.Operator.XOR, this, y);
    }

    public final ReExpression imp(ReExpression y) {
        return new BiLoExpression(LoExpression.Operator.IMP, this, y);
    }

    public final ReExpression iff(ReExpression ... y) {
        return new NaLoExpression(LoExpression.Operator.IFF, this, y);
    }

    public final ReExpression not() {
        return new UnLoExpression(LoExpression.Operator.NOT, this);
    }

    public static enum Operator {
        LT{

            @Override
            boolean eval(int i1, int i2) {
                return i1 < i2;
            }
        }
        ,
        LE{

            @Override
            boolean eval(int i1, int i2) {
                return i1 <= i2;
            }
        }
        ,
        GE{

            @Override
            boolean eval(int i1, int i2) {
                return i1 >= i2;
            }
        }
        ,
        GT{

            @Override
            boolean eval(int i1, int i2) {
                return i1 > i2;
            }
        }
        ,
        NE{

            @Override
            boolean eval(int i1, int i2) {
                return i1 != i2;
            }
        }
        ,
        EQ{

            @Override
            boolean eval(int i1, int i2) {
                return i1 == i2;
            }
        };


        abstract boolean eval(int var1, int var2);
    }
}

