/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.expression.discrete.relational;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.exception.SolverException;
import org.chocosolver.solver.expression.discrete.arithmetic.ArExpression;
import org.chocosolver.solver.expression.discrete.relational.ReExpression;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.util.tools.ArrayUtils;

public class NaReExpression
extends ReExpression {
    Model model;
    BoolVar me = null;
    ReExpression.Operator op = null;
    private ArExpression[] es;

    public NaReExpression(ReExpression.Operator op, ArExpression e, ArExpression ... es) {
        this(op, ArrayUtils.append({e}, es));
    }

    public NaReExpression(ReExpression.Operator op, ArExpression ... es) {
        this.model = es[0].getModel();
        this.op = op;
        this.es = es;
    }

    @Override
    public Model getModel() {
        return this.model;
    }

    @Override
    public BoolVar boolVar() {
        if (this.me == null) {
            IntVar[] vs = (IntVar[])Arrays.stream(this.es).map(ArExpression::intVar).toArray(IntVar[]::new);
            this.me = this.model.boolVar(this.model.generateName((Object)((Object)this.op) + "_exp_"));
            switch (this.op) {
                case EQ: {
                    if (vs.length == 2) {
                        this.model.reifyXeqY(vs[0], vs[1], this.me);
                        break;
                    }
                    IntVar count = this.model.intVar((Object)((Object)this.op) + "_count_", 1, vs.length);
                    this.model.atMostNValues(vs, count, false).post();
                    this.model.reifyXltC(count, 2, this.me);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Binary arithmetic expressions does not support " + this.op.name());
                }
            }
        }
        return this.me;
    }

    @Override
    public void extractVar(HashSet<IntVar> variables) {
        Arrays.stream(this.es).forEach(e -> e.extractVar(variables));
    }

    @Override
    public Constraint decompose() {
        IntVar[] vs = (IntVar[])Arrays.stream(this.es).map(ArExpression::intVar).toArray(IntVar[]::new);
        switch (this.op) {
            case EQ: {
                if (vs.length == 2) {
                    return this.model.arithm(vs[0], "=", vs[1]);
                }
                return this.model.allEqual(vs);
            }
        }
        throw new SolverException("Unexpected case");
    }

    @Override
    public boolean beval(int[] values, Map<IntVar, Integer> map) {
        boolean eval = true;
        for (int i = 1; i < this.es.length; ++i) {
            eval &= this.op.eval(this.es[0].ieval(values, map), this.es[i].ieval(values, map));
        }
        return eval;
    }

    public String toString() {
        return this.op.name() + "(" + this.es[0].toString() + ", ...," + this.es[this.es.length - 1].toString() + ")";
    }
}

