/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.expression.discrete.relational;

import java.util.HashSet;
import java.util.Map;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.exception.SolverException;
import org.chocosolver.solver.expression.discrete.arithmetic.ArExpression;
import org.chocosolver.solver.expression.discrete.relational.ReExpression;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IntVar;

public class BiReExpression
extends ReExpression {
    Model model;
    BoolVar me = null;
    ReExpression.Operator op = null;
    private ArExpression e1;
    private ArExpression e2;

    public BiReExpression(ReExpression.Operator op, ArExpression e1, ArExpression e2) {
        this.model = e1.getModel();
        this.op = op;
        this.e1 = e1;
        this.e2 = e2;
    }

    @Override
    public Model getModel() {
        return this.model;
    }

    @Override
    public BoolVar boolVar() {
        if (this.me == null) {
            IntVar v1 = this.e1.intVar();
            IntVar v2 = this.e2.intVar();
            this.me = this.model.boolVar(this.model.generateName((Object)((Object)this.op) + "_exp_"));
            switch (this.op) {
                case LT: {
                    this.model.reifyXltY(v1, v2, this.me);
                    break;
                }
                case LE: {
                    this.model.reifyXleY(v1, v2, this.me);
                    break;
                }
                case GE: {
                    this.model.reifyXleY(v2, v1, this.me);
                    break;
                }
                case GT: {
                    this.model.reifyXltY(v2, v1, this.me);
                    break;
                }
                case NE: {
                    this.model.reifyXneY(v1, v2, this.me);
                    break;
                }
                case EQ: {
                    this.model.reifyXeqY(v1, v2, this.me);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Binary arithmetic expressions does not support " + this.op.name());
                }
            }
        }
        return this.me;
    }

    @Override
    public void extractVar(HashSet<IntVar> variables) {
        this.e1.extractVar(variables);
        this.e2.extractVar(variables);
    }

    @Override
    public Constraint decompose() {
        IntVar v1 = this.e1.intVar();
        IntVar v2 = this.e2.intVar();
        Model model = v1.getModel();
        switch (this.op) {
            case LT: {
                return model.arithm(v1, "<", v2);
            }
            case LE: {
                return model.arithm(v1, "<=", v2);
            }
            case GE: {
                return model.arithm(v1, ">=", v2);
            }
            case GT: {
                return model.arithm(v1, ">", v2);
            }
            case NE: {
                return model.arithm(v1, "!=", v2);
            }
            case EQ: {
                return model.arithm(v1, "=", v2);
            }
        }
        throw new SolverException("Unexpected case");
    }

    @Override
    public boolean beval(int[] values, Map<IntVar, Integer> map) {
        return this.op.eval(this.e1.ieval(values, map), this.e2.ieval(values, map));
    }

    public String toString() {
        return this.op.name() + "(" + this.e1.toString() + "," + this.e2.toString() + ")";
    }
}

