/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.expression.discrete.logical;

import java.util.HashSet;
import java.util.Map;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.exception.SolverException;
import org.chocosolver.solver.expression.discrete.logical.LoExpression;
import org.chocosolver.solver.expression.discrete.relational.ReExpression;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IntVar;

public class UnLoExpression
extends LoExpression {
    Model model;
    BoolVar me = null;
    LoExpression.Operator op = null;
    private ReExpression e;

    public UnLoExpression(LoExpression.Operator op, ReExpression e) {
        this.model = e.getModel();
        this.op = op;
        this.e = e;
    }

    @Override
    public Model getModel() {
        return this.model;
    }

    @Override
    public BoolVar boolVar() {
        if (this.me == null) {
            BoolVar b = this.e.boolVar();
            switch (this.op) {
                case NOT: {
                    this.me = this.model.boolNotView(b);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unary logical expressions does not support " + this.op.name());
                }
            }
        }
        return this.me;
    }

    @Override
    public void extractVar(HashSet<IntVar> variables) {
        this.e.extractVar(variables);
    }

    @Override
    public Constraint decompose() {
        BoolVar v1 = this.e.boolVar();
        Model model = v1.getModel();
        switch (this.op) {
            case NOT: {
                return model.arithm((IntVar)v1, "<", 1);
            }
        }
        throw new SolverException("Unexpected case");
    }

    @Override
    public boolean beval(int[] values, Map<IntVar, Integer> map) {
        return this.op.eval(this.e.beval(values, map), true);
    }

    public String toString() {
        return this.op.name() + "(" + this.e.toString() + ")";
    }
}

