/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.expression.discrete.logical;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.expression.discrete.logical.LoExpression;
import org.chocosolver.solver.expression.discrete.relational.ReExpression;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.util.tools.ArrayUtils;

public class NaLoExpression
extends LoExpression {
    Model model;
    BoolVar me = null;
    LoExpression.Operator op = null;
    private ReExpression[] es;

    public NaLoExpression(LoExpression.Operator op, ReExpression ... es) {
        this.op = op;
        this.es = es;
        this.model = es[0].getModel();
    }

    public NaLoExpression(LoExpression.Operator op, ReExpression e, ReExpression ... es) {
        this(op, ArrayUtils.append({e}, es));
    }

    @Override
    public Model getModel() {
        return this.model;
    }

    @Override
    public BoolVar boolVar() {
        if (this.me == null) {
            IntVar[] vs = (BoolVar[])Arrays.stream(this.es).map(e -> e.boolVar()).toArray(BoolVar[]::new);
            this.me = this.model.boolVar(this.model.generateName((Object)((Object)this.op) + "_exp_"));
            switch (this.op) {
                case AND: {
                    this.model.addClausesBoolAndArrayEqVar((BoolVar[])vs, this.me);
                    break;
                }
                case OR: {
                    this.model.addClausesBoolOrArrayEqVar((BoolVar[])vs, this.me);
                    break;
                }
                case IFF: {
                    if (vs.length == 2) {
                        this.model.reifyXeqY(vs[0], vs[1], this.me);
                        break;
                    }
                    IntVar count = this.model.intVar((Object)((Object)this.op) + "_count_", 1, 2);
                    this.model.atMostNValues(vs, count, false).post();
                    this.model.reifyXltC(count, 2, this.me);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("N-ary logical expressions does not support " + this.op.name());
                }
            }
        }
        return this.me;
    }

    @Override
    public void extractVar(HashSet<IntVar> variables) {
        Arrays.stream(this.es).forEach(e -> e.extractVar(variables));
    }

    @Override
    public Constraint decompose() {
        IntVar[] vs = (BoolVar[])Arrays.stream(this.es).map(e -> e.boolVar()).toArray(BoolVar[]::new);
        switch (this.op) {
            case AND: {
                return this.model.sum((BoolVar[])vs, "=", vs.length);
            }
            case OR: {
                return this.model.sum((BoolVar[])vs, ">", 0);
            }
            case IFF: {
                if (vs.length == 2) {
                    return this.model.arithm(vs[0], "=", vs[1]);
                }
                return this.model.allEqual(vs);
            }
        }
        throw new UnsupportedOperationException("N-ary logical expressions does not support " + this.op.name());
    }

    @Override
    public boolean beval(int[] values, Map<IntVar, Integer> map) {
        boolean eval = true;
        for (int i = 1; i < this.es.length; ++i) {
            eval &= this.op.eval(this.es[0].beval(values, map), this.es[i].beval(values, map));
        }
        return eval;
    }

    public String toString() {
        return this.op.name() + "(" + this.es[0].toString() + ",... ," + this.es[this.es.length - 1].toString() + ")";
    }
}

