/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.expression.discrete.arithmetic;

import java.util.Arrays;
import java.util.Map;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.expression.discrete.arithmetic.ArExpression;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.util.tools.ArrayUtils;
import org.chocosolver.util.tools.VariableUtils;

public class NaArExpression
implements ArExpression {
    Model model;
    IntVar me = null;
    ArExpression.Operator op = null;
    private ArExpression[] es;

    public NaArExpression(ArExpression.Operator op, ArExpression e, ArExpression ... es) {
        this(op, ArrayUtils.append({e}, es));
    }

    public NaArExpression(ArExpression.Operator op, ArExpression ... es) {
        this.op = op;
        this.es = es;
        this.model = es[0].getModel();
    }

    @Override
    public Model getModel() {
        return this.model;
    }

    @Override
    public IntVar intVar() {
        if (this.me == null) {
            IntVar[] vs = (IntVar[])Arrays.stream(this.es).map(e -> e.intVar()).toArray(IntVar[]::new);
            switch (this.op) {
                case ADD: {
                    int[] bounds = VariableUtils.boundsForAddition(vs);
                    this.me = this.model.intVar(this.model.generateName("sum_exp_"), bounds[0], bounds[1]);
                    this.model.sum(vs, "=", this.me).post();
                    break;
                }
                case MUL: {
                    int[] bounds = VariableUtils.boundsForMultiplication(vs[0], vs[1]);
                    this.me = this.model.intVar(this.model.generateName("mul_exp_0_"), bounds[0], bounds[1]);
                    this.model.times(vs[0], vs[1], this.me).post();
                    for (int i = 2; i < vs.length; ++i) {
                        IntVar pre = this.me;
                        bounds = VariableUtils.boundsForMultiplication(pre, vs[i]);
                        this.me = this.model.intVar(this.model.generateName("mul_exp_0_"), bounds[0], bounds[1]);
                        this.model.times(pre, vs[i], this.me).post();
                    }
                    break;
                }
                case MIN: {
                    int[] bounds = VariableUtils.boundsForMinimum(vs);
                    this.me = this.model.intVar(this.model.generateName("min_exp_"), bounds[0], bounds[1]);
                    this.model.min(this.me, vs).post();
                    break;
                }
                case MAX: {
                    int[] bounds = VariableUtils.boundsForMaximum(vs);
                    this.me = this.model.intVar(this.model.generateName("max_exp_"), bounds[0], bounds[1]);
                    this.model.max(this.me, vs).post();
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Binary arithmetic expressions does not support " + this.op.name());
                }
            }
        }
        return this.me;
    }

    @Override
    public int ieval(int[] values, Map<IntVar, Integer> map) {
        return Arrays.stream(this.es).mapToInt(e -> e.ieval(values, map)).reduce(this.op.identity(), (e1, e2) -> this.op.eval(e1, e2));
    }

    @Override
    public ArExpression[] getExpressionChild() {
        return this.es;
    }

    public String toString() {
        return this.op.name() + "(" + this.es[0].toString() + ",... ," + this.es[this.es.length - 1].toString() + ")";
    }
}

