/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.expression.discrete.arithmetic;

import java.util.Map;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.constraints.extension.TuplesFactory;
import org.chocosolver.solver.expression.discrete.arithmetic.ArExpression;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.util.tools.MathUtils;
import org.chocosolver.util.tools.VariableUtils;

public class BiArExpression
implements ArExpression {
    Model model;
    IntVar me = null;
    ArExpression.Operator op = null;
    private ArExpression e1;
    private ArExpression e2;

    public BiArExpression(ArExpression.Operator op, ArExpression e1, ArExpression e2) {
        this.op = op;
        this.e1 = e1;
        this.e2 = e2;
        this.model = e1.getModel();
    }

    @Override
    public Model getModel() {
        return this.model;
    }

    @Override
    public IntVar intVar() {
        if (this.me == null) {
            IntVar v1 = this.e1.intVar();
            IntVar v2 = this.e2.intVar();
            switch (this.op) {
                case ADD: {
                    int[] bounds = VariableUtils.boundsForAddition(v1, v2);
                    this.me = this.model.intVar(this.model.generateName("sum_exp_"), bounds[0], bounds[1]);
                    this.model.arithm(v1, "+", v2, "=", this.me).post();
                    break;
                }
                case SUB: {
                    int[] bounds = VariableUtils.boundsForSubstraction(v1, v2);
                    this.me = this.model.intVar(this.model.generateName("sub_exp_"), bounds[0], bounds[1]);
                    this.model.arithm(v1, "-", v2, "=", this.me).post();
                    break;
                }
                case MUL: {
                    int[] bounds = VariableUtils.boundsForMultiplication(v1, v2);
                    this.me = this.model.intVar(this.model.generateName("mul_exp_"), bounds[0], bounds[1]);
                    this.model.times(v1, v2, this.me).post();
                    break;
                }
                case DIV: {
                    int[] bounds = VariableUtils.boundsForDivision(v1, v2);
                    this.me = this.model.intVar(this.model.generateName("div_exp_"), bounds[0], bounds[1]);
                    this.model.div(v1, v2, this.me).post();
                    break;
                }
                case MOD: {
                    int[] bounds = VariableUtils.boundsForModulo(v1, v2);
                    this.me = this.model.intVar(this.model.generateName("mod_exp_"), bounds[0], bounds[1]);
                    this.model.mod(v1, v2, this.me).post();
                    break;
                }
                case POW: {
                    int[] bounds = VariableUtils.boundsForPow(v1, v2);
                    this.me = this.model.intVar(this.model.generateName("pow_exp_"), bounds[0], bounds[1]);
                    this.model.table(new IntVar[]{v1, v2, this.me}, TuplesFactory.generateTuples(vs -> vs[2] == MathUtils.pow(vs[0], vs[1]), true, v1, v2, this.me)).post();
                    break;
                }
                case MIN: {
                    int[] bounds = VariableUtils.boundsForMinimum(v1, v2);
                    this.me = this.model.intVar(this.model.generateName("min_exp_"), bounds[0], bounds[1]);
                    this.model.min(this.me, v1, v2).post();
                    break;
                }
                case MAX: {
                    int[] bounds = VariableUtils.boundsForMaximum(v1, v2);
                    this.me = this.model.intVar(this.model.generateName("max_exp_"), bounds[0], bounds[1]);
                    this.model.max(this.me, v1, v2).post();
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Binary arithmetic expressions does not support " + this.op.name());
                }
            }
        }
        return this.me;
    }

    @Override
    public int ieval(int[] values, Map<IntVar, Integer> map) {
        return this.op.eval(this.e1.ieval(values, map), this.e2.ieval(values, map));
    }

    @Override
    public ArExpression[] getExpressionChild() {
        return new ArExpression[]{this.e1, this.e2};
    }

    public String toString() {
        return this.op.name() + "(" + this.e1.toString() + "," + this.e2.toString() + ")";
    }
}

