/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.expression.discrete.arithmetic;

import java.util.HashSet;
import java.util.Map;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.expression.discrete.arithmetic.BiArExpression;
import org.chocosolver.solver.expression.discrete.arithmetic.NaArExpression;
import org.chocosolver.solver.expression.discrete.arithmetic.UnArExpression;
import org.chocosolver.solver.expression.discrete.relational.BiReExpression;
import org.chocosolver.solver.expression.discrete.relational.NaReExpression;
import org.chocosolver.solver.expression.discrete.relational.ReExpression;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.util.tools.MathUtils;

public interface ArExpression {
    public static final ArExpression[] NO_CHILD;

    public Model getModel();

    public IntVar intVar();

    default public boolean isExpressionLeaf() {
        return false;
    }

    default public void extractVar(HashSet<IntVar> variables) {
        if (this.isExpressionLeaf()) {
            variables.add((IntVar)this);
        } else {
            for (ArExpression e : this.getExpressionChild()) {
                e.extractVar(variables);
            }
        }
    }

    default public int ieval(int[] values, Map<IntVar, Integer> map) {
        if (!2.$assertionsDisabled && !(this instanceof IntVar)) {
            throw new AssertionError();
        }
        return values[map.get(this)];
    }

    default public ArExpression[] getExpressionChild() {
        return NO_CHILD;
    }

    default public ArExpression neg() {
        return new UnArExpression(Operator.NEG, this);
    }

    default public ArExpression abs() {
        return new UnArExpression(Operator.ABS, this);
    }

    default public ArExpression add(int y) {
        return new BiArExpression(Operator.ADD, this, this.getModel().intVar(y));
    }

    default public ArExpression add(ArExpression y) {
        return new BiArExpression(Operator.ADD, this, y);
    }

    default public ArExpression add(ArExpression ... y) {
        return new NaArExpression(Operator.ADD, this, y);
    }

    default public ArExpression sub(int y) {
        return new BiArExpression(Operator.SUB, this, this.getModel().intVar(y));
    }

    default public ArExpression sub(ArExpression y) {
        return new BiArExpression(Operator.SUB, this, y);
    }

    default public ArExpression mul(int y) {
        return new BiArExpression(Operator.MUL, this, this.getModel().intVar(y));
    }

    default public ArExpression mul(ArExpression y) {
        return new BiArExpression(Operator.MUL, this, y);
    }

    default public ArExpression mul(ArExpression ... y) {
        return new NaArExpression(Operator.MUL, this, y);
    }

    default public ArExpression div(int y) {
        return new BiArExpression(Operator.DIV, this, this.getModel().intVar(y));
    }

    default public ArExpression div(ArExpression y) {
        return new BiArExpression(Operator.DIV, this, y);
    }

    default public ArExpression mod(int y) {
        return new BiArExpression(Operator.MOD, this, this.getModel().intVar(y));
    }

    default public ArExpression mod(ArExpression y) {
        return new BiArExpression(Operator.MOD, this, y);
    }

    default public ArExpression sqr() {
        return new UnArExpression(Operator.SQR, this);
    }

    default public ArExpression pow(int y) {
        return new BiArExpression(Operator.POW, this, this.getModel().intVar(y));
    }

    default public ArExpression pow(ArExpression y) {
        return new BiArExpression(Operator.POW, this, y);
    }

    default public ArExpression min(int y) {
        return new BiArExpression(Operator.MIN, this, this.getModel().intVar(y));
    }

    default public ArExpression min(ArExpression y) {
        return new BiArExpression(Operator.MIN, this, y);
    }

    default public ArExpression min(ArExpression ... y) {
        return new NaArExpression(Operator.MIN, this, y);
    }

    default public ArExpression max(int y) {
        return new BiArExpression(Operator.MAX, this, this.getModel().intVar(y));
    }

    default public ArExpression max(ArExpression y) {
        return new BiArExpression(Operator.MAX, this, y);
    }

    default public ArExpression max(ArExpression ... y) {
        return new NaArExpression(Operator.MAX, this, y);
    }

    default public ArExpression dist(int y) {
        return this.sub(y).abs();
    }

    default public ArExpression dist(ArExpression y) {
        return this.sub(y).abs();
    }

    default public ReExpression lt(int y) {
        return new BiReExpression(ReExpression.Operator.LT, this, this.getModel().intVar(y));
    }

    default public ReExpression lt(ArExpression y) {
        return new BiReExpression(ReExpression.Operator.LT, this, y);
    }

    default public ReExpression le(int y) {
        return new BiReExpression(ReExpression.Operator.LE, this, this.getModel().intVar(y));
    }

    default public ReExpression le(ArExpression y) {
        return new BiReExpression(ReExpression.Operator.LE, this, y);
    }

    default public ReExpression gt(int y) {
        return new BiReExpression(ReExpression.Operator.GT, this, this.getModel().intVar(y));
    }

    default public ReExpression gt(ArExpression y) {
        return new BiReExpression(ReExpression.Operator.GT, this, y);
    }

    default public ReExpression ge(int y) {
        return new BiReExpression(ReExpression.Operator.GE, this, this.getModel().intVar(y));
    }

    default public ReExpression ge(ArExpression y) {
        return new BiReExpression(ReExpression.Operator.GE, this, y);
    }

    default public ReExpression ne(int y) {
        return new BiReExpression(ReExpression.Operator.NE, this, this.getModel().intVar(y));
    }

    default public ReExpression ne(ArExpression y) {
        return new BiReExpression(ReExpression.Operator.NE, this, y);
    }

    default public ReExpression eq(int y) {
        return new BiReExpression(ReExpression.Operator.EQ, this, this.getModel().intVar(y));
    }

    default public ReExpression eq(ArExpression y) {
        return new BiReExpression(ReExpression.Operator.EQ, this, y);
    }

    default public ReExpression eq(ArExpression ... ys) {
        return new NaReExpression(ReExpression.Operator.EQ, this, ys);
    }

    static {
        if (2.$assertionsDisabled) {
            // empty if block
        }
        NO_CHILD = new ArExpression[0];
    }

    public static enum Operator {
        NEG{

            @Override
            int eval(int i1) {
                return -i1;
            }

            @Override
            int eval(int i1, int i2) {
                throw new UnsupportedOperationException();
            }

            @Override
            int identity() {
                return 0;
            }
        }
        ,
        ABS{

            @Override
            int eval(int i1) {
                return Math.abs(i1);
            }

            @Override
            int eval(int i1, int i2) {
                throw new UnsupportedOperationException();
            }

            @Override
            int identity() {
                return 0;
            }
        }
        ,
        ADD{

            @Override
            int eval(int i1) {
                throw new UnsupportedOperationException();
            }

            @Override
            int eval(int i1, int i2) {
                return MathUtils.safeAdd(i1, i2);
            }

            @Override
            int identity() {
                return 0;
            }
        }
        ,
        SUB{

            @Override
            int eval(int i1) {
                throw new UnsupportedOperationException();
            }

            @Override
            int eval(int i1, int i2) {
                return MathUtils.safeSubstract(i1, i2);
            }

            @Override
            int identity() {
                return 0;
            }
        }
        ,
        MUL{

            @Override
            int eval(int i1) {
                throw new UnsupportedOperationException();
            }

            @Override
            int eval(int i1, int i2) {
                return MathUtils.safeMultiply(i1, i2);
            }

            @Override
            int identity() {
                return 1;
            }
        }
        ,
        DIV{

            @Override
            int eval(int i1) {
                throw new UnsupportedOperationException();
            }

            @Override
            int eval(int i1, int i2) {
                if (i2 == 0) {
                    if (i1 > 0) {
                        return Integer.MAX_VALUE;
                    }
                    return Integer.MIN_VALUE;
                }
                return i1 / i2;
            }

            @Override
            int identity() {
                return 0;
            }
        }
        ,
        MOD{

            @Override
            int eval(int i1) {
                throw new UnsupportedOperationException();
            }

            @Override
            int eval(int i1, int i2) {
                if (i2 == 0) {
                    if (i1 > 0) {
                        return Integer.MAX_VALUE;
                    }
                    return Integer.MIN_VALUE;
                }
                return i1 % i2;
            }

            @Override
            int identity() {
                return 0;
            }
        }
        ,
        SQR{

            @Override
            int eval(int i1) {
                return MathUtils.safeMultiply(i1, i1);
            }

            @Override
            int eval(int i1, int i2) {
                throw new UnsupportedOperationException();
            }

            @Override
            int identity() {
                return 0;
            }
        }
        ,
        POW{

            @Override
            int eval(int i1) {
                throw new UnsupportedOperationException();
            }

            @Override
            int eval(int i1, int i2) {
                return MathUtils.pow(i1, i2);
            }

            @Override
            int identity() {
                return 0;
            }
        }
        ,
        MIN{

            @Override
            int eval(int i1) {
                throw new UnsupportedOperationException();
            }

            @Override
            int eval(int i1, int i2) {
                return Math.min(i1, i2);
            }

            @Override
            int identity() {
                return Integer.MAX_VALUE;
            }
        }
        ,
        MAX{

            @Override
            int eval(int i1) {
                throw new UnsupportedOperationException();
            }

            @Override
            int eval(int i1, int i2) {
                return Math.max(i1, i2);
            }

            @Override
            int identity() {
                return Integer.MIN_VALUE;
            }
        };


        abstract int eval(int var1);

        abstract int eval(int var1, int var2);

        abstract int identity();
    }
}

