/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.expression.continuous.arithmetic;

import org.chocosolver.solver.Model;
import org.chocosolver.solver.expression.continuous.arithmetic.CArExpression;
import org.chocosolver.solver.variables.RealVar;

public class UnCArExpression
implements CArExpression {
    Model model;
    RealVar me = null;
    CArExpression.Operator op = null;
    private CArExpression e;

    public UnCArExpression(CArExpression.Operator op, CArExpression exp) {
        this.op = op;
        this.e = exp;
        this.model = this.e.getModel();
    }

    @Override
    public Model getModel() {
        return this.model;
    }

    @Override
    public RealVar realVar(double p) {
        if (this.me == null) {
            RealVar v = this.e.realVar(p);
            switch (this.op) {
                case NEG: {
                    this.me = this.model.realVar(-v.getUB(), -v.getLB(), p);
                    this.model.realIbexGenericConstraint("{0}=-{1}", this.me, v).post();
                    break;
                }
                case ABS: {
                    this.me = this.model.realVar(0.0, Math.max(Math.abs(v.getLB()), Math.abs(v.getUB())), p);
                    this.model.realIbexGenericConstraint("{0}=abs({1})", this.me, v).post();
                    break;
                }
                case EXP: {
                    this.me = this.model.realVar(Math.min(Math.exp(v.getLB()), Math.exp(v.getUB())), Math.max(Math.exp(v.getLB()), Math.exp(v.getUB())), p);
                    this.model.realIbexGenericConstraint("{0}=exp({1})", this.me, v).post();
                    break;
                }
                case LN: {
                    this.me = this.model.realVar(Math.min(Math.log(v.getLB()), Math.log(v.getUB())), Math.max(Math.log(v.getLB()), Math.log(v.getUB())), p);
                    this.model.realIbexGenericConstraint("{0}=ln({1})", this.me, v).post();
                    break;
                }
                case SQRT: {
                    this.me = this.model.realVar(Math.min(Math.sqrt(v.getLB()), Math.sqrt(v.getUB())), Math.max(Math.sqrt(v.getLB()), Math.sqrt(v.getUB())), p);
                    this.model.realIbexGenericConstraint("{0}=sqrt({1})", this.me, v).post();
                    break;
                }
                case COS: {
                    this.me = this.model.realVar(-1.0, 1.0, p);
                    this.model.realIbexGenericConstraint("{0}=cos({1})", this.me, v).post();
                    break;
                }
                case SIN: {
                    this.me = this.model.realVar(0.0, 1.0, p);
                    this.model.realIbexGenericConstraint("{0}=sin({1})", this.me, v).post();
                    break;
                }
                case TAN: {
                    this.me = this.model.realVar(0.0, Double.POSITIVE_INFINITY, p);
                    this.model.realIbexGenericConstraint("{0}=tan({1})", this.me, v).post();
                    break;
                }
                case ACOS: {
                    this.me = this.model.realVar(0.0, Math.PI, p);
                    this.model.realIbexGenericConstraint("{0}=acos({1})", this.me, v).post();
                    break;
                }
                case ASIN: {
                    this.me = this.model.realVar(-1.5707963267948966, 1.5707963267948966, p);
                    this.model.realIbexGenericConstraint("{0}=asin({1})", this.me, v).post();
                    break;
                }
                case ATAN: {
                    this.me = this.model.realVar(-1.5707963267948966, 1.5707963267948966, p);
                    this.model.realIbexGenericConstraint("{0}=atan({1})", this.me, v).post();
                    break;
                }
                case COSH: {
                    this.me = this.model.realVar(0.0, Double.POSITIVE_INFINITY, p);
                    this.model.realIbexGenericConstraint("{0}=cosh({1})", this.me, v).post();
                    break;
                }
                case SINH: {
                    this.me = this.model.realVar(0.0, Double.POSITIVE_INFINITY, p);
                    this.model.realIbexGenericConstraint("{0}=sinh({1})", this.me, v).post();
                    break;
                }
                case TANH: {
                    this.me = this.model.realVar(0.0, Double.POSITIVE_INFINITY, p);
                    this.model.realIbexGenericConstraint("{0}=tanh({1})", this.me, v).post();
                    break;
                }
                case ACOSH: {
                    this.me = this.model.realVar(0.0, Double.POSITIVE_INFINITY, p);
                    this.model.realIbexGenericConstraint("{0}=acosh({1})", this.me, v).post();
                    break;
                }
                case ASINH: {
                    this.me = this.model.realVar(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, p);
                    this.model.realIbexGenericConstraint("{0}=asinh({1})", this.me, v).post();
                    break;
                }
                case ATANH: {
                    this.me = this.model.realVar(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, p);
                    this.model.realIbexGenericConstraint("{0}=atanh({1})", this.me, v).post();
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unary arithmetic expressions does not support " + this.op.name());
                }
            }
        }
        return this.me;
    }

    public String toString() {
        return this.op.name() + "(" + this.e.toString() + ")";
    }
}

