/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.expression.continuous.arithmetic;

import org.chocosolver.solver.Model;
import org.chocosolver.solver.expression.continuous.arithmetic.CArExpression;
import org.chocosolver.solver.variables.RealVar;
import org.chocosolver.util.tools.VariableUtils;

public class BiCArExpression
implements CArExpression {
    Model model;
    RealVar me = null;
    CArExpression.Operator op = null;
    private CArExpression e1;
    private CArExpression e2;

    public BiCArExpression(CArExpression.Operator op, CArExpression e1, CArExpression e2) {
        this.op = op;
        this.e1 = e1;
        this.e2 = e2;
        this.model = e1.getModel();
    }

    @Override
    public Model getModel() {
        return this.model;
    }

    @Override
    public RealVar realVar(double p) {
        if (this.me == null) {
            RealVar v1 = this.e1.realVar(p);
            RealVar v2 = this.e2.realVar(p);
            switch (this.op) {
                case ADD: {
                    double[] bounds = VariableUtils.boundsForAddition(v1, v2);
                    this.me = this.model.realVar(bounds[0], bounds[1], p);
                    this.model.realIbexGenericConstraint("{0}={1}+{2}", this.me, v1, v2).post();
                    break;
                }
                case SUB: {
                    double[] bounds = VariableUtils.boundsForSubstraction(v1, v2);
                    this.me = this.model.realVar(bounds[0], bounds[1], p);
                    this.model.realIbexGenericConstraint("{0}={1}-{2}", this.me, v1, v2).post();
                    break;
                }
                case MUL: {
                    double[] bounds = VariableUtils.boundsForMultiplication(v1, v2);
                    this.me = this.model.realVar(bounds[0], bounds[1], p);
                    this.model.realIbexGenericConstraint("{0}={1}*{2}", this.me, v1, v2).post();
                    break;
                }
                case DIV: {
                    double[] bounds = VariableUtils.boundsForDivision(v1, v2);
                    this.me = this.model.realVar(bounds[0], bounds[1], p);
                    this.model.realIbexGenericConstraint("{0}={1}/{2}", this.me, v1, v2).post();
                    break;
                }
                case POW: {
                    double[] bounds = VariableUtils.boundsForPow(v1, v2);
                    this.me = this.model.realVar(bounds[0], bounds[1], p);
                    this.model.realIbexGenericConstraint("{0}={1}^{2}", this.me, v1, v2).post();
                    break;
                }
                case MIN: {
                    double[] bounds = VariableUtils.boundsForMinimum(v1, v2);
                    this.me = this.model.realVar(bounds[0], bounds[1], p);
                    this.model.realIbexGenericConstraint("{0}=min({1},{2})", this.me, v1, v2).post();
                    break;
                }
                case MAX: {
                    double[] bounds = VariableUtils.boundsForMaximum(v1, v2);
                    this.me = this.model.realVar(bounds[0], bounds[1], p);
                    this.model.realIbexGenericConstraint("{0}=max({1},{2})", this.me, v1, v2).post();
                    break;
                }
                case ATAN2: {
                    double[] bounds = VariableUtils.boundsForAtan2(v1, v2);
                    this.me = this.model.realVar(bounds[0], bounds[1], p);
                    this.model.realIbexGenericConstraint("{0}=atan2({1},{2})", this.me, v1, v2).post();
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Binary arithmetic expressions does not support " + this.op.name());
                }
            }
        }
        return this.me;
    }

    public String toString() {
        return this.op.name() + "(" + this.e1.toString() + "," + this.e2.toString() + ")";
    }
}

