/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.explanations;

import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.util.BitSet;

public class Rules {
    private static final int NO_ENTRY = Integer.MIN_VALUE;
    private BitSet paRules = new BitSet();
    private BitSet vmRules = new BitSet();
    private int[] vmMasks;
    private NoIteratorIntHashSet[] remVal;

    public Rules(int i1, int i2) {
        this.vmMasks = new int[i1];
        this.remVal = new NoIteratorIntHashSet[i2];
    }

    public boolean getPaRules(int pid) {
        return this.paRules.get(pid);
    }

    public void paRulesClear(int pid) {
        this.paRules.clear(pid);
    }

    public void addPaRules(int pid) {
        this.paRules.set(pid);
    }

    public int getVmRules(int vid) {
        if (vid < this.vmMasks.length && this.vmRules.get(vid)) {
            return this.vmMasks[vid];
        }
        return Integer.MIN_VALUE;
    }

    private void ensureRemvalCapacity(int size) {
        if (size >= this.remVal.length) {
            int nsize = Math.max(size, this.remVal.length * 3 / 2 + 1);
            NoIteratorIntHashSet[] tmp = this.remVal;
            this.remVal = new NoIteratorIntHashSet[nsize];
            System.arraycopy(tmp, 0, this.remVal, 0, tmp.length);
        }
    }

    public TIntSet getVmRemval(int vid) {
        this.ensureRemvalCapacity(vid + 1);
        NoIteratorIntHashSet remvals = this.remVal[vid];
        if (remvals == null) {
            this.remVal[vid] = remvals = new NoIteratorIntHashSet(16, 0.5f, Integer.MIN_VALUE);
        }
        return this.remVal[vid];
    }

    private void ensureRulesCapacity(int size) {
        if (size >= this.vmMasks.length) {
            int nsize = Math.max(size, this.vmMasks.length * 3 / 2 + 1);
            int[] tmp = this.vmMasks;
            this.vmMasks = new int[nsize];
            System.arraycopy(tmp, 0, this.vmMasks, 0, tmp.length);
        }
    }

    public boolean putMask(int vid, int mask) {
        this.ensureRulesCapacity(vid + 1);
        int cmask = this.vmMasks[vid];
        if (!this.vmRules.get(vid)) {
            this.vmMasks[vid] = mask;
            this.vmRules.set(vid);
            return true;
        }
        int amount = (cmask | mask) - cmask;
        int n = vid;
        this.vmMasks[n] = this.vmMasks[n] + amount;
        return amount > 0;
    }

    public void clear() {
        this.paRules.clear();
        int i = this.vmRules.nextSetBit(0);
        while (i > -1) {
            if (i < this.remVal.length && this.remVal[i] != null) {
                this.remVal[i].clear();
            }
            i = this.vmRules.nextSetBit(i + 1);
        }
        this.vmRules.clear();
    }

    public boolean intersect(int i1, int i2, int vid) {
        assert (vid < this.remVal.length && this.remVal[vid].size() > 0);
        while (i1 <= i2 && !this.remVal[vid].contains(i1)) {
            ++i1;
        }
        return i1 <= i2;
    }

    public void or(Rules rules) {
        if (rules != null) {
            this.paRules.or(rules.paRules);
            int i = rules.vmRules.nextSetBit(0);
            while (i > -1) {
                this.putMask(i, rules.vmMasks[i]);
                if (i < rules.remVal.length && rules.remVal[i] != null && rules.remVal[i].size() > 0) {
                    this.ensureRemvalCapacity(i + 1);
                    if (this.remVal[i] == null) {
                        this.remVal[i] = new NoIteratorIntHashSet(16, 0.5f, Integer.MIN_VALUE);
                    }
                    rules.remVal[i].addAllIn(this.remVal[i]);
                }
                i = rules.vmRules.nextSetBit(i + 1);
            }
        }
    }

    public boolean isEmpty() {
        return this.paRules.isEmpty() && this.vmRules.isEmpty();
    }

    private static class NoIteratorIntHashSet
    extends TIntHashSet {
        public NoIteratorIntHashSet(int initial_capacity, float load_factor, int no_entry_value) {
            super(initial_capacity, load_factor, no_entry_value);
        }

        public NoIteratorIntHashSet() {
        }

        public void addAllIn(NoIteratorIntHashSet aset) {
            int i = this._states.length;
            while (i-- > 0) {
                if (this._states[i] != 1) continue;
                aset.add(this._set[i]);
            }
        }
    }
}

