/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.explanations;

import gnu.trove.set.TIntSet;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.exception.SolverException;
import org.chocosolver.solver.explanations.ArrayEventStore;
import org.chocosolver.solver.explanations.Explanation;
import org.chocosolver.solver.explanations.Rules;
import org.chocosolver.solver.search.strategy.decision.Decision;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IEventType;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.solver.variables.events.PropagatorEventType;

public class RuleStore {
    private static final int NO_ENTRY = Integer.MIN_VALUE;
    protected static final int DM = 15;
    protected static final int BD = 7;
    protected static final int UB = 5;
    protected static final int LB = 3;
    protected static final int RM = 1;
    private Rules cRules;
    private Explanation[] decRefut;
    private final boolean saveCauses;
    private final boolean enablePartialExplanation;
    private boolean preemptedStop;
    private IntVar lastVar;
    private IEventType lastEvt;
    private int lastValue;

    public RuleStore(boolean saveCauses, boolean enablePartialExplanation) {
        this.saveCauses = saveCauses;
        this.enablePartialExplanation = enablePartialExplanation;
        this.decRefut = new Explanation[16];
    }

    public void init(Explanation expl) {
        this.cRules = expl.getRules();
        this.preemptedStop = false;
    }

    public boolean isPreemptedStop() {
        return this.preemptedStop;
    }

    public boolean match(int idx, ArrayEventStore eventStore) {
        this.lastVar = eventStore.getVariable(idx);
        this.lastValue = eventStore.getFirstValue(idx);
        this.lastEvt = eventStore.getEventType(idx);
        if (this.lastEvt != PropagatorEventType.FULL_PROPAGATION) {
            int lastVid = this.lastVar.getId();
            int lastMask = this.cRules.getVmRules(lastVid);
            if (lastMask == 15) {
                return true;
            }
            if (lastMask != Integer.MIN_VALUE) {
                IntEventType ievt = (IntEventType)this.lastEvt;
                return this.matchDomain(lastMask, this.lastVar, ievt, this.lastValue, eventStore.getSecondValue(idx), eventStore.getThirdValue(idx));
            }
            return false;
        }
        return this.cRules.getPaRules(this.lastValue);
    }

    public boolean matchDomain(int ruleMask, IntVar ivar, IntEventType evt, int i1, int i2, int i3) {
        int vid = ivar.getId();
        switch (ruleMask) {
            case 15: {
                return true;
            }
            case 7: {
                switch (evt) {
                    case INSTANTIATE: 
                    case DECUPP: 
                    case INCLOW: {
                        return true;
                    }
                    case REMOVE: {
                        return i1 < ivar.getLB() || i1 > ivar.getUB();
                    }
                }
            }
            case 5: {
                switch (evt) {
                    case INSTANTIATE: {
                        return i1 < i3;
                    }
                    case DECUPP: {
                        return true;
                    }
                    case INCLOW: {
                        return false;
                    }
                    case REMOVE: {
                        return i1 > ivar.getUB();
                    }
                }
            }
            case 3: {
                switch (evt) {
                    case INSTANTIATE: {
                        return i1 > i2;
                    }
                    case DECUPP: {
                        return false;
                    }
                    case INCLOW: {
                        return true;
                    }
                    case REMOVE: {
                        return i1 < ivar.getLB();
                    }
                }
            }
            case 1: {
                if (!ivar.hasEnumeratedDomain()) break;
                switch (evt) {
                    case INSTANTIATE: {
                        return this.cRules.intersect(i2, i3, vid);
                    }
                    case DECUPP: {
                        return this.cRules.intersect(i1, i2, vid);
                    }
                    case INCLOW: {
                        return this.cRules.intersect(i2, i1, vid);
                    }
                    case REMOVE: {
                        return this.cRules.getVmRemval(vid).contains(i1);
                    }
                }
            }
        }
        throw new SolverException("Unknown event");
    }

    public void update(int idx, ArrayEventStore eventStore, Explanation explanation) {
        assert (this.lastVar == eventStore.getVariable(idx)) : "Wrong variable loaded";
        assert (this.lastEvt == eventStore.getEventType(idx)) : "Wrong event loaded";
        if (!this.lastEvt.equals(PropagatorEventType.FULL_PROPAGATION)) {
            ICause lastCause = eventStore.getCause(idx);
            if (lastCause instanceof Decision) {
                Decision decision = (Decision)lastCause;
                if (decision.hasNext() || decision.getArity() == 1) {
                    explanation.addDecision(decision);
                    if (decision.getArity() > 1 && (this.preemptedStop |= this.enablePartialExplanation)) {
                        explanation.setEvtstrIdx(idx);
                    }
                } else if (decision.getArity() > 1) {
                    Explanation drr = this.getDecisionRefutation(decision);
                    assert (drr != null) : "No explanation for decision refutation :" + decision.toString();
                    explanation.addCausesAndDecisions(drr);
                    explanation.addRules(drr.getRules());
                }
                if (!this.saveCauses) {
                    this.preemptedStop |= explanation.getDecisions().previousClearBit(decision.getPosition()) == 0;
                }
            } else {
                assert (this.lastValue == eventStore.getFirstValue(idx)) : "Wrong value loaded";
                explanation.addCause(lastCause);
                lastCause.why(this, this.lastVar, this.lastEvt, this.lastValue);
            }
        } else {
            this.addFullDomainRule(this.lastVar);
            this.cRules.paRulesClear(this.lastValue);
        }
    }

    public boolean addRemovalRule(IntVar var, int value) {
        if (var.hasEnumeratedDomain()) {
            int vid = var.getId();
            this.cRules.putMask(vid, 1);
            TIntSet remvals = this.cRules.getVmRemval(vid);
            return remvals.add(value);
        }
        if (value <= var.getLB()) {
            return this.addLowerBoundRule(var);
        }
        if (value >= var.getUB()) {
            return this.addUpperBoundRule(var);
        }
        throw new SolverException("Cannot add REMOVE rule for bounded variable");
    }

    public boolean addFullDomainRule(IntVar var) {
        return this.cRules.putMask(var.getId(), 15);
    }

    public boolean addLowerBoundRule(IntVar var) {
        return this.cRules.putMask(var.getId(), 3);
    }

    public boolean addUpperBoundRule(IntVar var) {
        return this.cRules.putMask(var.getId(), 5);
    }

    public boolean addBoundsRule(IntVar var) {
        return this.cRules.putMask(var.getId(), 7);
    }

    public int getMask(Variable var) {
        return this.cRules.getVmRules(var.getId());
    }

    public boolean addPropagatorActivationRule(Propagator propagator) {
        this.cRules.addPaRules(propagator.getId());
        return false;
    }

    public void storeDecisionRefutation(Decision decision, Explanation explanation) {
        int w = decision.getPosition();
        if (w >= this.decRefut.length) {
            Explanation[] tmp = this.decRefut;
            this.decRefut = new Explanation[w + 10];
            System.arraycopy(tmp, 0, this.decRefut, 0, tmp.length);
        }
        assert (explanation == null || w >= explanation.getDecisions().length());
        this.decRefut[w] = explanation;
    }

    public void moveDecisionRefutation(Decision decision, int to) {
        assert (to <= decision.getPosition());
        if (to < decision.getPosition()) {
            this.decRefut[to] = this.decRefut[decision.getPosition()];
            this.decRefut[decision.getPosition()] = null;
        }
    }

    public void freeDecisionExplanation(Decision decision) {
        int w = decision.getPosition();
        if (w < this.decRefut.length && this.decRefut[w] != null) {
            this.decRefut[w].recycle();
            this.decRefut[w] = null;
        }
    }

    public Explanation getDecisionRefutation(Decision decision) {
        assert (decision.triesLeft() < 2) : decision.toString() + "is not explained yet";
        return this.decRefut[decision.getPosition()];
    }
}

