/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.explanations;

import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.explanations.ArrayEventStore;
import org.chocosolver.solver.explanations.Explanation;
import org.chocosolver.solver.explanations.IExplanationEngine;
import org.chocosolver.solver.explanations.RuleStore;
import org.chocosolver.solver.search.strategy.decision.Decision;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.solver.variables.events.PropagatorEventType;
import org.chocosolver.solver.variables.view.IView;
import org.chocosolver.util.PoolManager;

public class ExplanationEngine
implements IExplanationEngine {
    private final ArrayEventStore eventStore;
    private final RuleStore ruleStore;
    private final boolean saveCauses;
    private final boolean enablePartialExplanation;
    private PoolManager<Explanation> explanationPool;

    public ExplanationEngine(Model model, boolean partialExplanationsOn, boolean recordCauses) {
        this.saveCauses = recordCauses;
        this.enablePartialExplanation = partialExplanationsOn;
        this.eventStore = new ArrayEventStore(model.getEnvironment());
        this.ruleStore = new RuleStore(this.saveCauses, this.enablePartialExplanation);
        model.getSolver().setExplainer(this);
        this.explanationPool = new PoolManager();
    }

    @Override
    public boolean isSaveCauses() {
        return this.saveCauses;
    }

    @Override
    public Explanation explain(ContradictionException cex) {
        Explanation explanation = this.makeExplanation(this.saveCauses);
        this.ruleStore.init(explanation);
        if (cex.v != null) {
            this.ruleStore.addFullDomainRule((IntVar)cex.v);
        } else {
            explanation.addCause(cex.c);
            cex.c.why(this.ruleStore, null, IntEventType.VOID, 0);
        }
        for (int i = this.eventStore.getSize() - 1; i > -1 && !this.ruleStore.isPreemptedStop(); --i) {
            if (!this.ruleStore.match(i, this.eventStore)) continue;
            this.ruleStore.update(i, this.eventStore, explanation);
        }
        if (!this.enablePartialExplanation) {
            explanation.getRules().clear();
        }
        return explanation;
    }

    @Override
    public Explanation makeExplanation(boolean saveCauses) {
        Explanation explanation = this.explanationPool.getE();
        if (explanation == null) {
            explanation = new Explanation(this.explanationPool, saveCauses);
        }
        return explanation;
    }

    @Override
    public RuleStore getRuleStore() {
        return this.ruleStore;
    }

    @Override
    public ArrayEventStore getEventStore() {
        return this.eventStore;
    }

    @Override
    public Explanation getDecisionRefutationExplanation(Decision decision) {
        return this.ruleStore.getDecisionRefutation(decision);
    }

    @Override
    public void storeDecisionExplanation(Decision decision, Explanation explanation) {
        this.ruleStore.storeDecisionRefutation(decision, explanation);
    }

    @Override
    public void moveDecisionRefutation(Decision decision, int to) {
        this.ruleStore.moveDecisionRefutation(decision, to);
    }

    @Override
    public void freeDecisionExplanation(Decision decision) {
        this.ruleStore.freeDecisionExplanation(decision);
    }

    @Override
    public void removeValue(IntVar var, int val, ICause cause) {
        this.eventStore.pushEvent(var, cause, IntEventType.REMOVE, val, -1, -1);
        for (IView view : var.getViews()) {
            if (view == cause) continue;
            view.justifyEvent(var, cause, IntEventType.REMOVE, val, -1, -1);
        }
    }

    @Override
    public void updateLowerBound(IntVar var, int value, int old, ICause cause) {
        this.eventStore.pushEvent(var, cause, IntEventType.INCLOW, value, old, -1);
        for (IView view : var.getViews()) {
            if (view == cause) continue;
            view.justifyEvent(var, cause, IntEventType.INCLOW, value, old, -1);
        }
    }

    @Override
    public void updateUpperBound(IntVar var, int value, int old, ICause cause) {
        this.eventStore.pushEvent(var, cause, IntEventType.DECUPP, value, old, -1);
        for (IView view : var.getViews()) {
            if (view == cause) continue;
            view.justifyEvent(var, cause, IntEventType.DECUPP, value, old, -1);
        }
    }

    @Override
    public void instantiateTo(IntVar var, int val, ICause cause, int oldLB, int oldUB) {
        this.eventStore.pushEvent(var, cause, IntEventType.INSTANTIATE, val, oldLB, oldUB);
        for (IView view : var.getViews()) {
            if (view == cause) continue;
            view.justifyEvent(var, cause, IntEventType.INSTANTIATE, val, oldLB, oldUB);
        }
    }

    @Override
    public void activePropagator(BoolVar var, Propagator propagator) {
        this.eventStore.pushEvent(var, propagator, PropagatorEventType.FULL_PROPAGATION, propagator.getId(), 0, 0);
    }

    @Override
    public void undo() {
        this.eventStore.forgetLast();
    }
}

