/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.explanations;

import gnu.trove.set.hash.THashSet;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Set;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.explanations.Rules;
import org.chocosolver.solver.search.strategy.decision.Decision;
import org.chocosolver.util.PoolManager;

public class Explanation {
    private final boolean saveCauses;
    private Rules rules;
    private final THashSet<ICause> causes = new THashSet();
    private final BitSet decisions = new BitSet();
    private int evtstrIdx;
    private final PoolManager<Explanation> explanationPool;

    Explanation(PoolManager<Explanation> explanationPool, boolean saveCauses) {
        this.saveCauses = saveCauses;
        this.explanationPool = explanationPool;
        this.rules = new Rules(16, 16);
    }

    public boolean addCause(ICause cause) {
        return this.saveCauses && this.causes.add(cause);
    }

    public void addDecision(Decision decision) {
        this.decisions.set(decision.getPosition());
    }

    public int nbCauses() {
        return this.causes.size();
    }

    public int nbDecisions() {
        return this.decisions.cardinality();
    }

    public void addCausesAndDecisions(Explanation explanation) {
        if (explanation.nbCauses() > 0) {
            this.causes.addAll(explanation.causes);
        }
        if (explanation.nbDecisions() > 0) {
            this.decisions.or(explanation.decisions);
        }
    }

    public void addRules(Rules someRules) {
        this.rules.or(someRules);
    }

    public boolean remove(ICause cause) {
        return this.causes.remove(cause);
    }

    public void remove(Decision decision) {
        this.decisions.clear(decision.getPosition());
    }

    public BitSet getDecisions() {
        return this.decisions;
    }

    public Set<ICause> getCauses() {
        return Collections.unmodifiableSet(this.causes);
    }

    public boolean isComplete() {
        return this.rules.isEmpty();
    }

    public int getEvtstrIdx() {
        return this.evtstrIdx;
    }

    public void setEvtstrIdx(int evtstrIdx) {
        this.evtstrIdx = evtstrIdx;
    }

    public Rules getRules() {
        return this.rules;
    }

    public String toString() {
        StringBuilder st = new StringBuilder("Explanation ");
        if (this.saveCauses) {
            st.append(Arrays.toString(this.causes.toArray()));
        }
        st.append(this.decisions);
        if (this.rules != null) {
            st.append(this.rules.toString());
        }
        return st.toString();
    }

    public void recycle() {
        this.evtstrIdx = 0;
        this.causes.clear();
        this.decisions.clear();
        this.rules.clear();
        this.explanationPool.returnE(this);
    }
}

