/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.explanations;

import org.chocosolver.memory.IEnvironment;
import org.chocosolver.memory.IStateInt;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.events.IEventType;

public class ArrayEventStore {
    private static final int SIZE = 128;
    private IntVar[] varChunks;
    private ICause[] cauChunks;
    private IEventType[] masChunks;
    private int[] val1Chunks;
    private int[] val2Chunks;
    private int[] val3Chunks;
    private IStateInt size;

    public ArrayEventStore(IEnvironment env) {
        this.size = env.makeInt(0);
        this.size._set(0, 0);
        this.varChunks = new IntVar[128];
        this.cauChunks = new ICause[128];
        this.masChunks = new IEventType[128];
        this.val1Chunks = new int[128];
        this.val2Chunks = new int[128];
        this.val3Chunks = new int[128];
    }

    public void pushEvent(IntVar var, ICause cause, IEventType mask, int one, int two, int three) {
        int idx = this.size.get();
        if (idx >= this.varChunks.length) {
            this.increase();
        }
        this.varChunks[idx] = var;
        this.cauChunks[idx] = cause;
        this.masChunks[idx] = mask;
        this.val1Chunks[idx] = one;
        this.val2Chunks[idx] = two;
        this.val3Chunks[idx] = three;
        this.size.add(1);
    }

    public void forgetLast() {
        this.size.add(-1);
    }

    private void increase() {
        int oldCapacity = this.varChunks.length;
        int newCapacity = oldCapacity + (oldCapacity >> 1);
        IntVar[] varBigger = new IntVar[newCapacity];
        System.arraycopy(this.varChunks, 0, varBigger, 0, oldCapacity);
        this.varChunks = varBigger;
        ICause[] cauBigger = new ICause[newCapacity];
        System.arraycopy(this.cauChunks, 0, cauBigger, 0, oldCapacity);
        this.cauChunks = cauBigger;
        IEventType[] masBigger = new IEventType[newCapacity];
        System.arraycopy(this.masChunks, 0, masBigger, 0, oldCapacity);
        this.masChunks = masBigger;
        int[] valBigger = new int[newCapacity];
        System.arraycopy(this.val1Chunks, 0, valBigger, 0, oldCapacity);
        this.val1Chunks = valBigger;
        valBigger = new int[newCapacity];
        System.arraycopy(this.val2Chunks, 0, valBigger, 0, oldCapacity);
        this.val2Chunks = valBigger;
        valBigger = new int[newCapacity];
        System.arraycopy(this.val3Chunks, 0, valBigger, 0, oldCapacity);
        this.val3Chunks = valBigger;
    }

    public int getSize() {
        return this.size.get();
    }

    public IntVar getVariable(int evt) {
        return this.varChunks[evt];
    }

    public IEventType getEventType(int evt) {
        return this.masChunks[evt];
    }

    public ICause getCause(int evt) {
        return this.cauChunks[evt];
    }

    public int getFirstValue(int evt) {
        return this.val1Chunks[evt];
    }

    public int getSecondValue(int evt) {
        return this.val2Chunks[evt];
    }

    public int getThirdValue(int evt) {
        return this.val3Chunks[evt];
    }
}

